/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.decorators;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import org.happy.collections.decorators.CollectionDecorator_1x0;
import org.happy.collections.decorators.EventCollection_1x0;
import org.happy.collections.decorators.UnmodifiableStrategy_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0Impl;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;

public class UnmodifiableCollection_1x0<E>
extends CollectionDecorator_1x0<E, Collection<E>> {
    private EventCollection_1x0<E> eventCollection;
    private Delegate_1x0Impl<ActionEventAfter_1x0<UnmodifiableStrategy_1x0>> onStrategyChanged = null;
    private UnmodifiableStrategy_1x0 strategy;
    protected ActionListener beforeAddListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            throw new UnsupportedOperationException("The collection can't be modified! Choose another strategy than " + UnmodifiableCollection_1x0.this.strategy.toString() + ", if you want to add elements");
        }
    };
    protected ActionListener beforeRemoveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            throw new UnsupportedOperationException("The collection can't be modified! Choose another strategy than " + UnmodifiableCollection_1x0.this.strategy.toString() + ", if you want to remove elements");
        }
    };

    public static <E> UnmodifiableCollection_1x0<E> of(Collection<E> decorateable) {
        return UnmodifiableCollection_1x0.of(decorateable, UnmodifiableStrategy_1x0.Unmodifiable);
    }

    public static <E> UnmodifiableCollection_1x0<E> of(Collection<E> decorateable, UnmodifiableStrategy_1x0 strategy) {
        return new UnmodifiableCollection_1x0<E>(decorateable, strategy);
    }

    public UnmodifiableCollection_1x0(Collection<E> decorateable) {
        this(decorateable, UnmodifiableStrategy_1x0.Unmodifiable);
    }

    public UnmodifiableCollection_1x0(Collection<E> decorateable, UnmodifiableStrategy_1x0 strategy) {
        super(decorateable);
        this.eventCollection = this.createEventCollection(decorateable);
        this.setStrategy(strategy);
    }

    protected EventCollection_1x0<E> createEventCollection(Collection<E> decorateable) {
        return EventCollection_1x0.of(decorateable);
    }

    protected EventCollection_1x0<E> getEventCollection() {
        return this.eventCollection;
    }

    protected void removeAllListeners() {
        this.eventCollection.getOnBeforeAddEvent().remove(this.beforeAddListener);
        this.eventCollection.getOnBeforeRemoveEvent().remove(this.beforeRemoveListener);
        this.eventCollection.getOnBeforeClearEvent().remove(this.beforeRemoveListener);
    }

    public UnmodifiableStrategy_1x0 getStrategy() {
        return this.strategy;
    }

    public void setStrategy(UnmodifiableStrategy_1x0 strategy) {
        boolean strategyHasChanged = false;
        strategyHasChanged = this.strategy == null ? true : !this.strategy.equals(strategy);
        this.strategy = strategy;
        this.removeAllListeners();
        if (UnmodifiableStrategy_1x0.RemoveAllowed.equals(this.strategy) || UnmodifiableStrategy_1x0.Unmodifiable.equals(this.strategy)) {
            this.eventCollection.getOnBeforeAddEvent().add(this.beforeAddListener);
        }
        if (UnmodifiableStrategy_1x0.AddAllowed.equals(this.strategy) || UnmodifiableStrategy_1x0.Unmodifiable.equals(this.strategy)) {
            this.eventCollection.getOnBeforeRemoveEvent().add(this.beforeRemoveListener);
            this.eventCollection.getOnBeforeClearEvent().add(this.beforeRemoveListener);
        }
        if (strategyHasChanged) {
            this.fireOnStrategyChanged(strategy);
        }
    }

    protected void fireOnStrategyChanged(UnmodifiableStrategy_1x0 newStragegy) {
        if (this.onStrategyChanged == null) {
            return;
        }
        this.onStrategyChanged.fire(new ActionEventAfter_1x0<UnmodifiableStrategy_1x0>((Object)this, 0, "unmodifiable-strategy has changed", newStragegy));
    }

    public Delegate_1x0Impl<ActionEventAfter_1x0<UnmodifiableStrategy_1x0>> getOnStrategyChanged() {
        if (this.onStrategyChanged == null) {
            this.onStrategyChanged = new Delegate_1x0Impl();
        }
        return this.onStrategyChanged;
    }

    @Override
    protected Iterator<E> iteratorImpl() {
        throw new Error("this code shuold be never called, because the listIterator() - method is overriden");
    }

    @Override
    public void setDecorated(Collection<E> decorated) {
        this.eventCollection.setDecorated(decorated);
        super.setDecorated(decorated);
    }

    @Override
    public boolean add(E o) {
        return this.eventCollection.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.eventCollection.addAll(c);
    }

    @Override
    public void clear() {
        this.eventCollection.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.eventCollection.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.eventCollection.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.eventCollection.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.eventCollection.retainAll(c);
    }
}

