/*
 * Decompiled with CFR 0.152.
 */
package motifSets;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import motifSets.Distance;
import motifSets.MK;

public class ScanMK {
    private int n;
    private double r;
    private int topK;
    private ArrayList<ArrayList<Integer>> motifSet;
    private double[][] data;
    private double[][] origData;

    public ScanMK(double[][] data, int w, double r, int topK) {
        this.n = w;
        this.r = r;
        this.topK = topK;
        this.motifSet = new ArrayList();
        this.data = data;
        this.origData = (double[][])data.clone();
    }

    public void scanTimeSeries() {
        SubSequenceSet alpha = new SubSequenceSet(this.data);
        double range = 0.0;
        boolean end = false;
        ArrayList motifs = new ArrayList();
        while (range <= this.r && !end) {
            MK mk = new MK(alpha.getData(), this.topK, this.n);
            range = mk.getDistance();
            end = true;
            if (!(range <= this.r)) continue;
            end = false;
            int[] places = new int[]{alpha.convertIndicies(mk.getLocations())[0], alpha.convertIndicies(mk.getLocations())[1]};
            double[] first = alpha.getSubseq(mk.getLocations()[0]);
            double[] second = alpha.getSubseq(mk.getLocations()[1]);
            double[][] locations = new double[][]{first, second};
            this.data = alpha.removeTrivialMatches(mk.getLocations());
            int[] mot = this.linearScan(this.data, this.r, locations);
            boolean matches = true;
            if (mot[0] == -1) {
                matches = false;
            }
            if (matches) {
                int[] mot2 = alpha.convertIndicies(mot);
                mot2 = this.removeTrivialMatchesA(mot2, this.origData, locations);
                mot2 = this.removeTrivialMatchesB(mot2, this.origData, locations, this.n);
                mot2 = this.condense(mot2, this.origData, this.r);
                alpha.removeTrivialMatchesNoConvert(mot2);
                ArrayList<Integer> tmp = new ArrayList<Integer>();
                tmp.add(places[0]);
                tmp.add(places[1]);
                for (int i = 0; i < mot2.length; ++i) {
                    tmp.add(mot2[i]);
                }
                motifs.add(tmp);
                continue;
            }
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            tmp.add(places[0]);
            tmp.add(places[1]);
            motifs.add(tmp);
        }
        this.motifSet = motifs;
    }

    private int[] linearScan(double[][] data, double r, double[][] seq) {
        int[] places;
        ArrayList<Integer> locs = new ArrayList<Integer>();
        for (int i = 0; i < data.length; ++i) {
            if (!(Distance.distAban(seq[0], data[i], r) < r) || !(Distance.distAban(seq[1], data[i], r) < r)) continue;
            locs.add(i);
        }
        if (!locs.isEmpty()) {
            places = new int[locs.size()];
            for (int i = 0; i < locs.size(); ++i) {
                places[i] = (Integer)locs.get(i);
            }
        } else {
            places = new int[]{-1};
        }
        return places;
    }

    private int[] removeTrivialMatchesA(int[] locs, double[][] data, double[][] locations) {
        int count = 1;
        ArrayList<Integer> group = new ArrayList<Integer>();
        for (int i = 0; i < locs.length - 1; ++i) {
            if (locs[i + 1] - locs[i] == 1) {
                ++count;
                continue;
            }
            group.add(count);
            count = 1;
        }
        group.add(count);
        int done = 0;
        int[] mot = new int[group.size()];
        for (int i = 0; i < group.size(); ++i) {
            double best = Double.MAX_VALUE;
            for (int j = done; j < done + (Integer)group.get(i); ++j) {
                double dist = Distance.distance(data[locs[j]], locations[0]) + Distance.distance(data[locs[j]], locations[1]);
                for (int k = 0; k < mot.length; ++k) {
                    dist += Distance.distance(data[locs[j]], data[mot[k]]);
                }
                if (!(dist < best)) continue;
                best = dist;
                mot[i] = locs[j];
            }
            done += ((Integer)group.get(i)).intValue();
        }
        return mot;
    }

    private int[] removeTrivialMatchesB(int[] locs, double[][] data, double[][] locations, int n) {
        int count = 1;
        while (count > 0) {
            int i;
            int[] trivs = new int[locs.length];
            for (int i2 = 0; i2 < trivs.length; ++i2) {
                trivs[i2] = 0;
                for (int j = 0; j < locs.length; ++j) {
                    if (Math.abs(locs[i2] - locs[j]) >= n || locs[i2] == locs[j]) continue;
                    int n2 = i2;
                    trivs[n2] = trivs[n2] + 1;
                }
            }
            count = 0;
            double dists = 0.0;
            int pos = 0;
            double maxDist = 0.0;
            for (int i3 = 0; i3 < trivs.length; ++i3) {
                int j;
                count += trivs[i3];
                if (trivs[i3] <= 0) continue;
                for (j = 0; j < locations.length; ++j) {
                    dists += Distance.distance(data[locs[i3]], locations[j]);
                }
                for (j = 0; j < locs.length; ++j) {
                    if (i3 == j) continue;
                    dists += Distance.distance(data[locs[i3]], data[locs[j]]);
                }
                if (!(dists > maxDist)) continue;
                maxDist = dists;
                pos = i3;
            }
            if (count <= 0) continue;
            int[] nloc = new int[locs.length - 1];
            for (i = 0; i < pos; ++i) {
                nloc[i] = locs[i];
            }
            for (i = pos + 1; i < locs.length; ++i) {
                nloc[i - 1] = locs[i];
            }
            locs = nloc;
        }
        return locs;
    }

    private int[] condense(int[] locs, double[][] data, double r) {
        int[] clash = this.clash(locs, data, r);
        int total = 0;
        for (int i = 0; i < clash.length; ++i) {
            total += clash[i];
        }
        while (total > 0) {
            int i;
            int i2;
            int most = 0;
            int position = 0;
            for (i2 = 0; i2 < clash.length; ++i2) {
                if (clash[i2] <= most) continue;
                most = clash[i2];
                position = i2;
            }
            for (i2 = 0; i2 < clash.length; ++i2) {
                if (clash[position] != clash[i2] || position == i2) continue;
                double distPo = 0.0;
                double distI = 0.0;
                for (int j = 0; j < locs.length; ++j) {
                    distPo += Distance.distance(data[locs[position]], data[locs[j]]);
                    distI += Distance.distance(data[locs[position]], data[locs[i2]]);
                }
                if (!(distI > distPo)) continue;
                position = i2;
            }
            int[] loca = new int[locs.length - 1];
            for (i = 0; i < position; ++i) {
                loca[i] = locs[i];
            }
            for (i = position + 1; i < locs.length; ++i) {
                loca[i - 1] = locs[i];
            }
            locs = loca;
            clash = this.clash(locs, data, r);
            total = 0;
            for (i = 0; i < clash.length; ++i) {
                total += clash[i];
            }
        }
        return locs;
    }

    private int[] clash(int[] locs, double[][] data, double r) {
        int[] clash = new int[locs.length];
        for (int i = 0; i < locs.length; ++i) {
            clash[i] = 0;
            for (int j = 0; j < locs.length; ++j) {
                if (!(Distance.distance(data[locs[i]], data[locs[j]]) > r)) continue;
                int n = i;
                clash[n] = clash[n] + 1;
            }
        }
        return clash;
    }

    public ArrayList<ArrayList<Integer>> getMotifSet() {
        return this.motifSet;
    }

    public void outputToFile(String outFile) throws IOException {
        PrintWriter cout = new PrintWriter((Writer)new FileWriter(outFile), true);
        cout.println("r/n");
        cout.println(this.r + "/" + this.n);
        String con = "";
        for (int i = 0; i < this.motifSet.size(); ++i) {
            String tmp = "";
            for (int j = 0; j < this.motifSet.get(i).size(); ++j) {
                tmp = tmp + this.motifSet.get(i).get(j) + ",";
            }
            con = con + tmp + "/";
        }
        cout.println(con);
    }

    public String toString() {
        return "";
    }

    public static class SubSequenceSet {
        ArrayList<double[]> set = new ArrayList();
        ArrayList<Boolean> in = new ArrayList();
        int n;

        public SubSequenceSet(double[][] data) {
            int i;
            for (i = 0; i < data.length; ++i) {
                this.set.add(data[i]);
            }
            this.n = data[0].length;
            for (i = 0; i < data.length; ++i) {
                this.in.add(true);
            }
        }

        public double[][] getData() {
            int i;
            ArrayList<double[]> datum = new ArrayList<double[]>();
            double[][] dat = new double[this.getNum()][];
            for (i = 0; i < this.set.size(); ++i) {
                if (!this.in.get(i).booleanValue()) continue;
                datum.add(this.set.get(i));
            }
            for (i = 0; i < datum.size(); ++i) {
                dat[i] = (double[])datum.get(i);
            }
            return dat;
        }

        public int getNum() {
            int count = 0;
            for (int i = 0; i < this.in.size(); ++i) {
                if (!this.in.get(i).booleanValue()) continue;
                ++count;
            }
            return count;
        }

        public void setIn(int inde, boolean val) {
            this.in.set(inde, val);
        }

        public int[] convertIndicies(int[] places) {
            int[] cardinal = new int[places.length];
            for (int i = 0; i < cardinal.length; ++i) {
                cardinal[i] = places[i] + 1;
            }
            block1: for (int j = 0; j < places.length; ++j) {
                int count = 0;
                for (int i = 0; i < this.in.size(); ++i) {
                    if (this.in.get(i).booleanValue()) {
                        ++count;
                    }
                    if (count != cardinal[j]) continue;
                    cardinal[j] = i;
                    continue block1;
                }
            }
            return cardinal;
        }

        public double[][] removeTrivialMatches(int[] locs) {
            int[] places = this.convertIndicies(locs);
            for (int j = 0; j < places.length; ++j) {
                int i;
                if (places[j] - (this.n - 1) >= 0) {
                    for (i = 0; i < this.n; ++i) {
                        this.setIn(places[j] - i, false);
                    }
                } else {
                    for (i = 0; i <= places[j]; ++i) {
                        this.setIn(places[j] - i, false);
                    }
                }
                if (places[j] + (this.n - 1) < this.set.size()) {
                    for (i = 0; i < this.n; ++i) {
                        this.setIn(places[j] + i, false);
                    }
                    continue;
                }
                i = 0;
                while (i + places[j] < this.set.size()) {
                    this.setIn(places[j] + i, false);
                    ++i;
                }
            }
            return this.getData();
        }

        public double[][] removeTrivialMatchesNoConvert(int[] locs) {
            int[] places = locs;
            for (int j = 0; j < places.length; ++j) {
                int i;
                if (places[j] - (this.n - 1) >= 0) {
                    for (i = 0; i < this.n; ++i) {
                        this.setIn(places[j] - i, false);
                    }
                } else {
                    for (i = 0; i <= places[j]; ++i) {
                        this.setIn(places[j] - i, false);
                    }
                }
                if (places[j] + (this.n - 1) < this.set.size()) {
                    for (i = 0; i < this.n; ++i) {
                        this.setIn(places[j] + i, false);
                    }
                    continue;
                }
                i = 0;
                while (i + places[j] < this.set.size()) {
                    this.setIn(places[j] + i, false);
                    ++i;
                }
            }
            return this.getData();
        }

        public double[] getSubseq(int index) {
            int[] num = new int[]{index};
            return this.set.get(this.convertIndicies(num)[0]);
        }
    }
}

