/*
 * Decompiled with CFR 0.152.
 */
package lm;

import lm.LearnMotifs;

public class TestScalability {
    private static String path = "/Users/bzcschae/workspace/motif-lets/datasets/";
    static String[] files = new String[]{"fNIRS_subLen_600.csv"};
    static double[] ranges = new double[]{10.0, 36.0};

    public static void main(String[] args) {
        int numRandomRestarts = 30;
        int maxIter = 300;
        double eta = 0.3;
        double alpha = 2.0;
        int motif_length = 100;
        int K = 3;
        for (int j = 0; j < files.length; ++j) {
            int i;
            String file_name = path + files[j];
            System.out.println(file_name);
            double motif_range = ranges[j];
            LearnMotifs lmParallel = new LearnMotifs();
            lmParallel.K = K;
            lmParallel.maxIter = maxIter;
            lmParallel.eta = eta;
            lmParallel.alpha = alpha;
            lmParallel.T = 2.0 * motif_range;
            lmParallel.LoadSegments(file_name, motif_length, 10000);
            double lmHardFrequency = lmParallel.RunParallelRandomRestarts(numRandomRestarts);
            int bestFrequency = 0;
            int frequency = 0;
            for (i = 0; i < K; ++i) {
                frequency = lmParallel.ComputeHardFrequency(lmParallel.bestM[i]);
                if (bestFrequency >= frequency) continue;
                bestFrequency = frequency;
            }
            System.out.println("Found Motif:");
            for (i = 0; i < K; ++i) {
                if (lmParallel.ComputeHardFrequency(lmParallel.bestM[i]) != bestFrequency) continue;
                lmParallel.PrintHardLocations(lmParallel.bestM[i]);
            }
        }
    }
}

