/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintStream;

class OutputChoice {
    final OutputChoiceType outputChoiceType;
    final PrintStream targetPrintStream;

    OutputChoice(OutputChoiceType outputChoiceType) {
        if (outputChoiceType == OutputChoiceType.FILE) {
            throw new IllegalArgumentException();
        }
        this.outputChoiceType = outputChoiceType;
        this.targetPrintStream = null;
    }

    OutputChoice(PrintStream printStream) {
        this.outputChoiceType = OutputChoiceType.FILE;
        this.targetPrintStream = printStream;
    }

    PrintStream getTargetPrintStream() {
        switch (this.outputChoiceType) {
            case SYS_OUT: {
                return System.out;
            }
            case SYS_ERR: {
                return System.err;
            }
            case FILE: {
                return this.targetPrintStream;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OutputChoiceType {
        SYS_OUT,
        SYS_ERR,
        FILE;

    }
}

