/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.discord;

import java.util.Arrays;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.discord.BruteForceDiscordImplementation;
import net.seninp.jmotif.sax.discord.DiscordRecord;
import net.seninp.jmotif.sax.discord.DiscordRecords;
import net.seninp.jmotif.sax.discord.HOTSAXImplementation;
import net.seninp.jmotif.sax.registry.LargeWindowAlgorithm;
import net.seninp.util.StackTrace;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDiscordDiscoveryNONE {
    private static final String TEST_DATA_FNAME = "src/resources/test-data/ecg0606_1.csv";
    private static final int WIN_SIZE = 100;
    private static final int PAA_SIZE = 3;
    private static final int ALPHABET_SIZE = 3;
    private static final double NORM_THRESHOLD = 0.01;
    private static final int DISCORDS_TO_TEST = 5;
    private static final NumerosityReductionStrategy STRATEGY = NumerosityReductionStrategy.NONE;
    private static final Logger LOGGER = LoggerFactory.getLogger(TestDiscordDiscoveryNONE.class);
    private double[] series;

    @Before
    public void setUp() throws Exception {
        this.series = TSProcessor.readFileColumn(TEST_DATA_FNAME, 0, 0);
        this.series = Arrays.copyOf(this.series, 800);
    }

    @Test
    public void test() {
        DiscordRecords discordsBruteForce = null;
        DiscordRecords discordsHash = null;
        DiscordRecords discordsOle = null;
        try {
            discordsBruteForce = BruteForceDiscordImplementation.series2BruteForceDiscords(this.series, 100, 5, new LargeWindowAlgorithm(), 0.01);
            for (DiscordRecord d : discordsBruteForce) {
                LOGGER.debug("brute force discord " + d.toString());
            }
            discordsHash = HOTSAXImplementation.series2Discords(this.series, 5, 100, 3, 3, STRATEGY, 0.01);
            for (DiscordRecord d : discordsHash) {
                LOGGER.debug("hotsax hash discord " + d.toString());
            }
            discordsOle = HOTSAXImplementation.series2DiscordsDeprecated(this.series, 5, 100, 3, 3, new LargeWindowAlgorithm(), STRATEGY, 0.01);
            for (DiscordRecord d : discordsOle) {
                LOGGER.debug("old hash discord " + d.toString());
            }
        }
        catch (Exception e) {
            Assert.fail("shouldn't throw an exception, exception thrown: \n" + StackTrace.toString(e));
            e.printStackTrace();
        }
        for (int i = 0; i < 5; ++i) {
            Double d1 = discordsBruteForce.get(i).getNNDistance();
            Double d2 = discordsHash.get(i).getNNDistance();
            Double d3 = discordsOle.get(i).getNNDistance();
            Assert.assertEquals(100L, discordsBruteForce.get(i).getLength());
            Assert.assertEquals(100L, discordsHash.get(i).getLength());
            Assert.assertEquals(100L, discordsOle.get(i).getLength());
            Assert.assertEquals(d1, d2);
            Assert.assertEquals(d1, d3);
        }
    }
}

