/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.datastructures;

import java.util.ArrayList;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.sax.datastructure.SAXRecord;
import net.seninp.jmotif.sax.datastructure.SAXRecords;
import org.junit.Assert;
import org.junit.Test;

public class TestSAXRecords {
    private static final String filenameTEK14 = "src/resources/test-data/TEK14.txt";

    @Test
    public void testProperIndexing() throws Exception {
        double[] ts1 = TSProcessor.readFileColumn(filenameTEK14, 0, 0);
        NormalAlphabet na = new NormalAlphabet();
        SAXProcessor sp = new SAXProcessor();
        SAXRecords res = sp.ts2saxViaWindow(ts1, 400, 6, na.getCuts(3), NumerosityReductionStrategy.EXACT, 0.01);
        String str = res.getSAXString(" ");
        res.buildIndex();
        String str1 = "";
        for (int i = 11; i < 47; ++i) {
            SAXRecord r = res.getByIndex(res.mapStringIndexToTSPosition(i));
            str1 = str1.concat(String.valueOf(r.getPayload()) + " ");
        }
        Assert.assertTrue("Asserting substring existence", str.indexOf(str1) > 0);
        Assert.assertEquals("Asserting substring the index", 77L, str.indexOf(str1));
    }

    @Test
    public void testNoneIndexing() throws Exception {
        int i;
        int slidinWindowSize = 100;
        double[] ts1 = TSProcessor.readFileColumn(filenameTEK14, 0, 0);
        NormalAlphabet na = new NormalAlphabet();
        SAXProcessor sp = new SAXProcessor();
        SAXRecords res = sp.ts2saxViaWindow(ts1, slidinWindowSize, 4, na.getCuts(3), NumerosityReductionStrategy.NONE, 0.01);
        for (int i2 = 0; i2 < ts1.length - slidinWindowSize; ++i2) {
            Assert.assertNotNull("Asserting the proper dicretization.", res.getByIndex(i2));
        }
        Assert.assertNull("Asserting the proper dicretization termination.", res.getByIndex(ts1.length - slidinWindowSize + 1));
        int excludedLen = 15;
        int excludedStart = 17;
        ArrayList<Integer> excluded = new ArrayList<Integer>(excludedLen);
        for (i = 0; i < excludedLen; ++i) {
            excluded.add(i + excludedStart);
        }
        res.excludePositions(excluded);
        Assert.assertNotNull("Asserting the proper dicretization.", res.getByIndex(excludedStart - 1));
        for (i = 0; i < excludedLen; ++i) {
            Assert.assertNull("Asserting the proper dicretization.", res.getByIndex(i + excludedStart));
        }
        Assert.assertNotNull("Asserting the proper dicretization.", res.getByIndex(excludedStart + excludedLen + 1));
        SAXRecord rec = res.getByIndex(res.getIndexes().iterator().next());
        String str = String.valueOf(rec.getPayload());
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        indexes.addAll(rec.getIndexes());
        for (Integer i3 : indexes) {
            res.dropByIndex(i3);
        }
        Assert.assertNull("Assert drop by index.", res.getByWord(str));
        SAXRecords records = new SAXRecords();
        for (Integer i4 : indexes) {
            records.add(str.toCharArray(), i4);
        }
        res.addAll(records);
        rec = res.getByWord(str);
        Assert.assertEquals("Asserting record indexes length", rec.getIndexes().size(), indexes.size());
    }

    @Test
    public void testToString() {
        SAXRecords sr = new SAXRecords();
        Assert.assertTrue(sr.getAllIndices().isEmpty());
        sr.add("aaa".toCharArray(), 10);
        sr.add("aaa".toCharArray(), 11);
        sr.add("bbb".toCharArray(), 13);
        Assert.assertTrue(sr.toString().contains("aaa -> [10, 11]"));
    }
}

