/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXException;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.Alphabet;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.sax.datastructure.SAXRecord;
import net.seninp.jmotif.sax.datastructure.SAXRecords;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSAXProcessor {
    private static final String ts1File = "src/resources/test-data/timeseries01.csv";
    private static final String ts2File = "src/resources/test-data/timeseries02.csv";
    private static final String ts3File = "src/resources/test-data/timeseries03.csv";
    private static final String ts1StrRep10 = "bcjkiheebb";
    private static final String ts2StrRep10 = "bcefgijkdb";
    private static final String ts1StrRep14 = "bcdijjhgfeecbb";
    private static final String ts2StrRep14 = "bbdeeffhijjfbb";
    private static final String ts1StrRep7 = "bcggfddba";
    private static final String ts2StrRep7 = "accdefgda";
    private static final int length = 15;
    private static final int strLength = 10;
    private static final Alphabet normalA = new NormalAlphabet();
    private static final double delta = 0.001;
    private static final Logger LOGGER = LoggerFactory.getLogger(TestSAXProcessor.class);

    @Test
    public void testConnectedConversion() throws NumberFormatException, IOException, SAXException {
        SAXProcessor sp = new SAXProcessor();
        double[] ts = TSProcessor.readFileColumn(ts3File, 0, 0);
        ArrayList<Integer> skips = new ArrayList<Integer>();
        for (int i = 24; i < 30; ++i) {
            skips.add(i);
        }
        SAXRecords regularSAX = sp.ts2saxViaWindow(ts, 6, 3, normalA.getCuts(3), NumerosityReductionStrategy.NONE, 0.01);
        LOGGER.debug("NONE: there are " + regularSAX.getAllIndices().size() + " words: \n" + regularSAX.getSAXString(" ") + "\n" + regularSAX.getAllIndices());
        SAXRecords saxData = sp.ts2saxViaWindowSkipping(ts, 6, 3, normalA.getCuts(3), NumerosityReductionStrategy.NONE, 0.01, skips);
        LOGGER.debug("NONE with skips: there are " + saxData.getAllIndices().size() + " words: \n" + saxData.getSAXString(" ") + "\n" + saxData.getAllIndices());
        regularSAX = sp.ts2saxViaWindow(ts, 6, 3, normalA.getCuts(3), NumerosityReductionStrategy.EXACT, 0.01);
        Assert.assertNotNull("asserting the processing result", regularSAX);
        LOGGER.debug("EXACT: there are " + regularSAX.getAllIndices().size() + " words: \n" + regularSAX.getSAXString(" ") + "\n" + regularSAX.getAllIndices());
        saxData = sp.ts2saxViaWindowSkipping(ts, 6, 3, normalA.getCuts(3), NumerosityReductionStrategy.EXACT, 0.01, skips);
        LOGGER.debug("EXACT with skips: there are " + saxData.getAllIndices().size() + " words: \n" + saxData.getSAXString(" ") + "\n" + saxData.getAllIndices());
    }

    @Test
    public void testTs2SAXByChunks() throws Exception {
        SAXProcessor sp = new SAXProcessor();
        TSProcessor tp = new TSProcessor();
        double[] ts1 = TSProcessor.readFileColumn(ts1File, 0, 15);
        double[] ts2 = TSProcessor.readFileColumn(ts2File, 0, 15);
        double[] ser = new double[]{-1.0, -2.0, -1.0, 0.0, 2.0, 1.0, 1.0, 0.0};
        LOGGER.debug(" ** " + Arrays.toString(tp.paa(ser, 3)));
        SAXRecords ts1sax = sp.ts2saxByChunking(ts1, 10, normalA.getCuts(11), 0.001);
        Assert.assertEquals("testing SAX", 10L, ts1sax.getSAXString("").length());
        Assert.assertTrue("testing SAX", ts1StrRep10.equalsIgnoreCase(ts1sax.getSAXString("")));
        Object[] bPositions = ts1sax.getByWord("b").getIndexes().toArray(new Integer[3]);
        Arrays.sort(bPositions);
        Assert.assertEquals(0L, ((Integer)bPositions[0]).intValue());
        Assert.assertEquals(12L, ((Integer)bPositions[1]).intValue());
        Assert.assertEquals(13L, ((Integer)bPositions[2]).intValue());
        String ts1sax2 = sp.ts2saxByChunking(ts1, 14, normalA.getCuts(10), 0.001).getSAXString("");
        Assert.assertEquals("testing SAX", 14L, ts1sax2.length());
        Assert.assertTrue("testing SAX", ts1StrRep14.equalsIgnoreCase(ts1sax2));
        String ts1sax3 = sp.ts2saxByChunking(ts1, 9, normalA.getCuts(7), 0.001).getSAXString("");
        Assert.assertEquals("testing SAX", 9L, ts1sax3.length());
        Assert.assertTrue("testing SAX", ts1StrRep7.equalsIgnoreCase(ts1sax3));
        String ts2sax = sp.ts2saxByChunking(ts2, 10, normalA.getCuts(11), 0.001).getSAXString("");
        Assert.assertEquals("testing SAX", 10L, ts2sax.length());
        Assert.assertTrue("testing SAX", ts2StrRep10.equalsIgnoreCase(ts2sax));
        ts2sax = sp.ts2saxByChunking(ts2, 14, normalA.getCuts(10), 0.001).getSAXString("");
        Assert.assertEquals("testing SAX", 14L, ts2sax.length());
        Assert.assertTrue("testing SAX", ts2StrRep14.equalsIgnoreCase(ts2sax));
        ts2sax = sp.ts2saxByChunking(ts2, 9, normalA.getCuts(7), 0.001).getSAXString("");
        Assert.assertEquals("testing SAX", 9L, ts2sax.length());
        Assert.assertTrue("testing SAX", ts2StrRep7.equalsIgnoreCase(ts2sax));
    }

    @Test
    public void testTs2SAXByGlobalChunks() throws Exception {
        SAXProcessor sp = new SAXProcessor();
        double[] ts1 = TSProcessor.readFileColumn(ts1File, 0, 15);
        SAXRecords saxdata = sp.ts2saxViaWindowGlobalZNorm(ts1, 5, 5, normalA.getCuts(3), NumerosityReductionStrategy.NONE, 0.01);
        SAXRecord entry = saxdata.getByIndex(7);
        Assert.assertTrue("ccbbb".equalsIgnoreCase(String.valueOf(entry.getPayload())));
    }

    @Test
    public void testTs2sax() throws Exception {
        TSProcessor tp = new TSProcessor();
        SAXProcessor sp = new SAXProcessor();
        double[] ts2 = TSProcessor.readFileColumn(ts2File, 0, 15);
        String ts2str_0 = sp.ts2saxByChunking(tp.subseriesByCopy(ts2, 0, 5), 5, normalA.getCuts(10), 0.001).getSAXString("");
        String ts2str_3 = sp.ts2saxByChunking(tp.subseriesByCopy(ts2, 3, 8), 5, normalA.getCuts(10), 0.001).getSAXString("");
        String ts2str_7 = sp.ts2saxByChunking(tp.subseriesByCopy(ts2, 7, 12), 5, normalA.getCuts(10), 0.001).getSAXString("");
        SAXRecords ts2SAX = sp.ts2saxViaWindow(ts2, 5, 5, normalA.getCuts(10), NumerosityReductionStrategy.NONE, 0.001);
        Assert.assertEquals("Testing conversion", ts2.length - 5 + 1, ts2SAX.size());
        Assert.assertNotNull("Testing ts2sax", ts2SAX.getByWord(ts2str_0));
        Assert.assertNotNull("Testing ts2sax", ts2SAX.getByWord(ts2str_3));
        Assert.assertNotNull("Testing ts2sax", ts2SAX.getByWord(ts2str_7));
        Assert.assertEquals("Testing ts2sax", ts2SAX.getByWord(ts2str_0).getIndexes().iterator().next(), new Integer(0));
        Assert.assertEquals("Testing ts2sax", ts2SAX.getByWord(ts2str_3).getIndexes().iterator().next(), new Integer(3));
        Assert.assertEquals("Testing ts2sax", ts2SAX.getByWord(ts2str_7).getIndexes().iterator().next(), new Integer(7));
        SAXRecords ts2SAXerror = null;
        try {
            ts2SAXerror = sp.ts2saxViaWindow(ts2, ts2.length + 1, 5, normalA.getCuts(10), NumerosityReductionStrategy.NONE, 0.001);
            Assert.fail("Exception must be thrown!");
        }
        catch (SAXException e) {
            Assert.assertNull(ts2SAXerror);
        }
    }

    @Test
    public void testMINDIST() {
        double a3distValue = 0.861455;
        double refDist = Math.sqrt(16.0) * Math.sqrt(1.4842094340499998);
        String a = "baabccbc";
        String b = "babcacca";
        SAXProcessor sp = new SAXProcessor();
        try {
            Assert.assertEquals(sp.saxMinDist("baabccbc".toCharArray(), "babcacca".toCharArray(), normalA.getDistanceMatrix(3), 128, 8), refDist, 0.001);
        }
        catch (SAXException e) {
            Assert.fail("exception shall not be thrown!");
        }
        try {
            Assert.assertEquals(sp.saxMinDist("baabcc4c".toCharArray(), "babcacca".toCharArray(), normalA.getDistanceMatrix(2), 128, 8), refDist, 0.001);
            Assert.fail("exception not thrown!");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            Assert.assertEquals(sp.saxMinDist("baabccc".toCharArray(), "babcacca".toCharArray(), normalA.getDistanceMatrix(2), 128, 8), refDist, 0.001);
            Assert.fail("exception not thrown!");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            Assert.assertEquals(sp.saxMinDist("baabccbc".toCharArray(), "babcacca".toCharArray(), normalA.getDistanceMatrix(2), 128, 8), refDist, 0.001);
            Assert.fail("exception not thrown!");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        Assert.assertFalse(sp.checkMinDistIsZero("baabccbc".toCharArray(), "babcacca".toCharArray()));
        Assert.assertTrue(sp.checkMinDistIsZero("aabbccdd".toCharArray(), "bbccddee".toCharArray()));
    }

    @Test
    public void testTs2String() {
        double[] series = new double[]{-1.0, -2.0, -1.0, 0.0, 2.0, 1.0, 1.0, 0.0};
        SAXProcessor sp = new SAXProcessor();
        try {
            Assert.assertTrue(String.valueOf(sp.ts2string(series, 3, normalA.getCuts(3), 0.001)).equals("acc"));
            Assert.assertTrue(String.valueOf(sp.ts2string(series, 8, normalA.getCuts(3), 0.001)).equals("aaabcccb"));
        }
        catch (SAXException e) {
            Assert.fail("exception shall not be thrown!");
        }
    }

    @Test
    public void testCharDistance() {
        SAXProcessor sp = new SAXProcessor();
        Assert.assertEquals(sp.charDistance('a', 'a'), 0L);
        Assert.assertEquals(sp.charDistance('a', 'c'), 2L);
        Assert.assertEquals(sp.charDistance('a', 'e'), 4L);
    }

    @Test
    public void testStrDistance() {
        SAXProcessor sp = new SAXProcessor();
        try {
            Assert.assertEquals(sp.strDistance("aaa".toCharArray(), "aaa".toCharArray()), 0L);
            Assert.assertEquals(sp.strDistance("aaa".toCharArray(), "aac".toCharArray()), 2L);
            Assert.assertEquals(sp.strDistance("aaa".toCharArray(), "abc".toCharArray()), 3L);
        }
        catch (SAXException e) {
            Assert.fail("exception shall not be thrown!");
        }
        try {
            Assert.assertEquals(sp.strDistance("aaa".toCharArray(), "aaaa".toCharArray()), 0L);
            Assert.fail("exception shall be thrown!");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }
}

