/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.seninp.jmotif.distance.EuclideanDistance;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXException;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.sax.datastructure.SAXRecord;
import net.seninp.jmotif.sax.datastructure.SAXRecords;
import org.joda.time.Duration;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public final class SAXProcessor {
    private final TSProcessor tsProcessor = new TSProcessor();
    private final NormalAlphabet na = new NormalAlphabet();
    private EuclideanDistance ed = new EuclideanDistance();

    public char[] ts2string(double[] ts, int paaSize, double[] cuts, double nThreshold) throws SAXException {
        if (paaSize == ts.length) {
            return this.tsProcessor.ts2String(this.tsProcessor.znorm(ts, nThreshold), cuts);
        }
        double[] paa = this.tsProcessor.paa(this.tsProcessor.znorm(ts, nThreshold), paaSize);
        return this.tsProcessor.ts2String(paa, cuts);
    }

    public SAXRecords ts2saxByChunking(double[] ts, int paaSize, double[] cuts, double nThreshold) throws SAXException {
        SAXRecords saxFrequencyData = new SAXRecords();
        double[] normalizedTS = this.tsProcessor.znorm(ts, nThreshold);
        double[] paa = this.tsProcessor.paa(normalizedTS, paaSize);
        char[] currentString = this.tsProcessor.ts2String(paa, cuts);
        for (int i = 0; i < currentString.length; ++i) {
            char c = currentString[i];
            int pos = (int)Math.floor(i * ts.length / currentString.length);
            saxFrequencyData.add(String.valueOf(c).toCharArray(), pos);
        }
        return saxFrequencyData;
    }

    public SAXRecords ts2saxViaWindow(double[] ts, int windowSize, int paaSize, double[] cuts, NumerosityReductionStrategy strategy, double nThreshold) throws SAXException {
        if (windowSize > ts.length) {
            throw new SAXException("Unable to saxify via window, window size is greater than the timeseries length...");
        }
        SAXRecords saxFrequencyData = new SAXRecords();
        char[] previousString = null;
        for (int i = 0; i <= ts.length - windowSize; ++i) {
            double[] subSection = Arrays.copyOfRange(ts, i, i + windowSize);
            subSection = this.tsProcessor.znorm(subSection, nThreshold);
            double[] paa = this.tsProcessor.paa(subSection, paaSize);
            char[] currentString = this.tsProcessor.ts2String(paa, cuts);
            if (null != previousString && (NumerosityReductionStrategy.EXACT.equals((Object)strategy) && Arrays.equals(previousString, currentString) || NumerosityReductionStrategy.MINDIST.equals((Object)strategy) && this.checkMinDistIsZero(previousString, currentString))) continue;
            previousString = currentString;
            saxFrequencyData.add(currentString, i);
        }
        return saxFrequencyData;
    }

    public SAXRecords ts2saxViaWindowGlobalZNorm(double[] ts, int windowSize, int paaSize, double[] cuts, NumerosityReductionStrategy strategy, double nThreshold) throws SAXException {
        SAXRecords saxFrequencyData = new SAXRecords();
        char[] previousString = null;
        double[] normalizedData = this.tsProcessor.znorm(ts, nThreshold);
        for (int i = 0; i <= ts.length - windowSize; ++i) {
            double[] subSection = Arrays.copyOfRange(normalizedData, i, i + windowSize);
            double[] paa = this.tsProcessor.paa(subSection, paaSize);
            char[] currentString = this.tsProcessor.ts2String(paa, cuts);
            if (null != previousString && (NumerosityReductionStrategy.EXACT.equals((Object)strategy) && Arrays.equals(previousString, currentString) || NumerosityReductionStrategy.MINDIST.equals((Object)strategy) && this.checkMinDistIsZero(previousString, currentString))) continue;
            previousString = currentString;
            saxFrequencyData.add(currentString, i);
        }
        return saxFrequencyData;
    }

    public SAXRecords ts2saxViaWindowSkipping(double[] ts, int windowSize, int paaSize, double[] cuts, NumerosityReductionStrategy strategy, double nThreshold, ArrayList<Integer> skips) throws SAXException {
        SAXRecords saxFrequencyData = new SAXRecords();
        Collections.sort(skips);
        int cSkipIdx = 0;
        char[] previousString = null;
        boolean skipped = false;
        for (int i = 0; i < ts.length - (windowSize - 1); ++i) {
            if (cSkipIdx < skips.size() && i == skips.get(cSkipIdx)) {
                ++cSkipIdx;
                skipped = true;
                continue;
            }
            double[] subSection = Arrays.copyOfRange(ts, i, i + windowSize);
            subSection = this.tsProcessor.znorm(subSection, nThreshold);
            double[] paa = this.tsProcessor.paa(subSection, paaSize);
            char[] currentString = this.tsProcessor.ts2String(paa, cuts);
            if (!skipped && null != previousString && (NumerosityReductionStrategy.EXACT.equals((Object)strategy) && Arrays.equals(previousString, currentString) || NumerosityReductionStrategy.MINDIST.equals((Object)strategy) && this.checkMinDistIsZero(previousString, currentString))) continue;
            previousString = currentString;
            if (skipped) {
                skipped = false;
            }
            saxFrequencyData.add(currentString, i);
        }
        return saxFrequencyData;
    }

    public int charDistance(char a, char b) {
        return Math.abs(Character.getNumericValue(a) - Character.getNumericValue(b));
    }

    public int strDistance(char[] a, char[] b) throws SAXException {
        if (a.length == b.length) {
            int distance = 0;
            for (int i = 0; i < a.length; ++i) {
                int tDist = Math.abs(Character.getNumericValue(a[i]) - Character.getNumericValue(b[i]));
                distance += tDist;
            }
            return distance;
        }
        throw new SAXException("Unable to compute SAX distance, string lengths are not equal");
    }

    public double saxMinDist(char[] a, char[] b, double[][] distanceMatrix, int n, int w) throws SAXException {
        if (a.length == b.length) {
            double dist = 0.0;
            for (int i = 0; i < a.length; ++i) {
                if (Character.isLetter(a[i]) && Character.isLetter(b[i])) {
                    int numA = Character.getNumericValue(a[i]) - 10;
                    int numB = Character.getNumericValue(b[i]) - 10;
                    int maxIdx = distanceMatrix[0].length;
                    if (numA > maxIdx - 1 || numA < 0 || numB > maxIdx - 1 || numB < 0) {
                        throw new SAXException("The character index greater than " + maxIdx + " or less than 0!");
                    }
                    double localDist = distanceMatrix[numA][numB];
                    dist += localDist * localDist;
                    continue;
                }
                throw new SAXException("Non-literal character found!");
            }
            return Math.sqrt((double)n / (double)w) * Math.sqrt(dist);
        }
        throw new SAXException("Data arrays lengths are not equal!");
    }

    public boolean checkMinDistIsZero(char[] a, char[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (this.charDistance(a[i], b[i]) <= 1) continue;
            return false;
        }
        return true;
    }

    public double approximationDistancePAA(double[] ts, int winSize, int paaSize, double normThreshold) throws Exception {
        double resDistance = 0.0;
        int windowCounter = 0;
        double pointsPerWindow = (double)winSize / (double)paaSize;
        for (int i = 0; i < ts.length - winSize + 1; ++i) {
            double[] subseries = Arrays.copyOfRange(ts, i, i + winSize);
            if (this.tsProcessor.stDev(subseries) > normThreshold) {
                subseries = this.tsProcessor.znorm(subseries, normThreshold);
            }
            double[] paa = this.tsProcessor.paa(subseries, paaSize);
            ++windowCounter;
            double subsequenceDistance = 0.0;
            for (int j = 0; j < subseries.length; ++j) {
                int paaIdx = (int)Math.floor(((double)j + 0.5) / pointsPerWindow);
                if (paaIdx < 0) {
                    paaIdx = 0;
                }
                if (paaIdx > paa.length) {
                    paaIdx = paa.length - 1;
                }
                subsequenceDistance += this.ed.distance(paa[paaIdx], subseries[j]);
            }
            resDistance += subsequenceDistance / (double)subseries.length;
        }
        return resDistance / (double)windowCounter;
    }

    public double approximationDistanceAlphabet(double[] ts, int winSize, int paaSize, int alphabetSize, double normThreshold) throws Exception {
        double resDistance = 0.0;
        int windowCounter = 0;
        double[] centralLines = this.na.getCentralCuts(alphabetSize);
        double[] cuts = this.na.getCuts(alphabetSize);
        for (int i = 0; i < ts.length - winSize + 1; ++i) {
            double[] subseries = Arrays.copyOfRange(ts, i, i + winSize);
            double subsequenceDistance = 0.0;
            if (this.tsProcessor.stDev(subseries) > normThreshold) {
                subseries = this.tsProcessor.znorm(subseries, normThreshold);
            }
            double[] paa = this.tsProcessor.paa(subseries, paaSize);
            int[] leterIndexes = this.tsProcessor.ts2Index(paa, cuts);
            ++windowCounter;
            for (int j = 0; j < paa.length; ++j) {
                int letterIdx = leterIndexes[j];
                double cLine = centralLines[letterIdx];
                subsequenceDistance += this.ed.distance(cLine, paa[j]);
            }
            resDistance += subsequenceDistance / (double)paa.length;
        }
        return resDistance / (double)windowCounter;
    }

    public Map<String, Integer> ts2Shingles(double[] series, int windowSize, int paaSize, int alphabetSize, NumerosityReductionStrategy strategy, double nrThreshold, int shingleSize) throws SAXException {
        String[] alphabet = new String[alphabetSize];
        for (int i = 0; i < alphabetSize; ++i) {
            alphabet[i] = String.valueOf(TSProcessor.ALPHABET[i]);
        }
        String[] allShingles = SAXProcessor.getAllPermutations(alphabet, shingleSize);
        HashMap<String, Integer> res = new HashMap<String, Integer>(allShingles.length);
        for (String s : allShingles) {
            res.put(s, 0);
        }
        SAXRecords saxData = this.ts2saxViaWindow(series, windowSize, paaSize, this.na.getCuts(alphabetSize), strategy, nrThreshold);
        for (SAXRecord sr : saxData) {
            String word = String.valueOf(sr.getPayload());
            int frequency = sr.getIndexes().size();
            for (int i = 0; i <= word.length() - shingleSize; ++i) {
                String shingle = word.substring(i, i + shingleSize);
                res.put(shingle, res.get(shingle) + frequency);
            }
        }
        return res;
    }

    public static String[] getAllPermutations(String[] alphabet, int wordLength) {
        String[] allLists = new String[(int)Math.pow(alphabet.length, wordLength)];
        if (wordLength == 1) {
            return alphabet;
        }
        String[] allSublists = SAXProcessor.getAllPermutations(alphabet, wordLength - 1);
        int arrayIndex = 0;
        for (int i = 0; i < alphabet.length; ++i) {
            for (int j = 0; j < allSublists.length; ++j) {
                allLists[arrayIndex] = alphabet[i] + allSublists[j];
                ++arrayIndex;
            }
        }
        return allLists;
    }

    public static String timeToString(long start, long finish) {
        Duration duration = new Duration(finish - start);
        PeriodFormatter formatter = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").appendMillis().appendSuffix("ms").toFormatter();
        return formatter.print(duration.toPeriod());
    }
}

