/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.util;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.happy.commons.util.FileUtils_1x0;

public class Zip_1x3 {
    private static final int BUFFER = 2048;

    private Zip_1x3() {
    }

    public static void extractZipToFileSystem(File zipFile, File destDir) throws IOException, IllegalArgumentException {
        ZipEntry entry;
        if (zipFile == null) {
            throw new IllegalArgumentException("zipFile can't be null!");
        }
        if (!zipFile.exists()) {
            throw new IllegalArgumentException("zipFile " + zipFile.getCanonicalPath() + " don't exist");
        }
        if (destDir == null) {
            throw new IllegalArgumentException("zipFile can't be null!");
        }
        if (!destDir.exists()) {
            throw new IllegalArgumentException("directory " + destDir.getCanonicalPath() + " don't exist");
        }
        if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("directory " + destDir.getCanonicalPath() + " is a file, but the directory is expected!");
        }
        FileInputStream fis = new FileInputStream(zipFile);
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(fis));
        while ((entry = zin.getNextEntry()) != null) {
            String filePath = FilenameUtils.concat((String)destDir.getCanonicalPath(), (String)entry.getName());
            File file = new File(filePath);
            FileUtils.forceMkdir((File)file.getParentFile());
            if (!file.createNewFile()) {
                throw new IllegalArgumentException("file " + file.getCanonicalPath() + " couldn't be created!");
            }
            if (!file.canWrite()) {
                throw new IllegalArgumentException("file " + file.getCanonicalPath() + " can't be written!");
            }
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
            int count = 0;
            byte[] data = new byte[2048];
            while ((count = zin.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        zin.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(String entryPath, File srcFile, ZipOutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));){
            int len;
            out.putNextEntry(new ZipEntry(entryPath));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.flush();
            out.closeEntry();
        }
    }

    private static void zipDir(File baseDir, File srcDir, FileFilter filter, ZipOutputStream out) throws IOException {
        File[] files = FileUtils_1x0.listFiles(srcDir, filter);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                Zip_1x3.zipDir(baseDir, files[i], filter, out);
                continue;
            }
            String relPath = baseDir.toURI().relativize(files[i].toURI()).getPath();
            Zip_1x3.zipFile(relPath, files[i], out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File srcDir, FileFilter filter, File destFile, int method) throws IOException {
        Preconditions.checkNotNull((Object)srcDir, (Object)"source directory was null");
        Preconditions.checkArgument((boolean)srcDir.isDirectory(), (Object)(srcDir + " is not a directory"));
        Preconditions.checkNotNull((Object)destFile, (Object)"destination zip file was null");
        out.setMethod(method);
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destFile)));){
            Zip_1x3.zipDir(srcDir, srcDir, filter, out);
        }
    }

    public static void zipDir(File srcDir, FileFilter filter, File destFile) throws IOException {
        Zip_1x3.zipDir(srcDir, filter, destFile, 8);
    }

    public static void zipDir(File srcDir, File destFile) throws IOException {
        Zip_1x3.zipDir(srcDir, null, destFile);
    }
}

