/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.generators;

import java.util.Random;
import org.happy.commons.patterns.Generator_1x0;
import org.happy.commons.patterns.version.Version_1x0;
import org.happy.commons.util.Random_1x0;

public class RandomDoubleGenerator_1x0
implements Generator_1x0<Double>,
Version_1x0<Float> {
    private double min;
    private double max;
    Random random = null;

    public RandomDoubleGenerator_1x0(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("MIN must be smaller or equals to MAX");
        }
        this.min = min;
        this.max = max;
    }

    public RandomDoubleGenerator_1x0(double min, double max, Random random) {
        this(min, max);
        this.random = random;
    }

    @Override
    public Double generate() {
        if (this.min == this.max) {
            return this.min;
        }
        if (this.random == null) {
            return this.min + Random_1x0.randomDouble(this.max - this.min);
        }
        return this.min + this.random.nextDouble() * (this.max - this.min);
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }

    public String toString() {
        return "RandomDoubleGenerator_1x0 [min=" + this.min + ", max=" + this.max + "]";
    }
}

