/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentUtils_1x2 {
    private static AtomicInteger threadID = new AtomicInteger(0);

    public static ExecutorService createFixedExecutorService(int numberOfThreads, final String name) {
        ThreadFactory threadFactory = new ThreadFactory(){
            AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(name + this.counter.incrementAndGet());
                return t;
            }
        };
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads, threadFactory);
        return executorService;
    }

    public static ExecutorService createCachedExecutorService(final String name) {
        ThreadFactory threadFactory = new ThreadFactory(){
            AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(name + this.counter.incrementAndGet());
                return t;
            }
        };
        ExecutorService executorService = Executors.newCachedThreadPool(threadFactory);
        return executorService;
    }

    public static ForkJoinPool createForkJoinPool(int taskNumber, final String name) {
        int parallelism = taskNumber;
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                MyForkJoinWorkerThread thread = new MyForkJoinWorkerThread(pool);
                thread.setName(name + ":" + threadID.incrementAndGet());
                return thread;
            }
        };
        Thread.UncaughtExceptionHandler handler = null;
        boolean asyncMode = true;
        return new ForkJoinPool(parallelism, factory, handler, asyncMode);
    }

    private static class MyForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        protected MyForkJoinWorkerThread(ForkJoinPool forkJoinPool) {
            super(forkJoinPool);
        }
    }
}

