/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.sets.decorators;

import java.util.Comparator;
import java.util.SortedSet;
import org.happy.collections.sets.decorators.CacheSet_1x0;

public class CacheSortedSet_1x0<E>
extends CacheSet_1x0<E>
implements SortedSet<E> {
    public static <E> CacheSortedSet_1x0<E> of(float cacheSize, SortedSet<E> set) {
        return new CacheSortedSet_1x0<E>(cacheSize, set);
    }

    public CacheSortedSet_1x0(float cacheSize, SortedSet<E> decorateable) {
        super(cacheSize, decorateable);
    }

    @Override
    public Comparator<? super E> comparator() {
        return ((SortedSet)this.decorated).comparator();
    }

    @Override
    public E first() {
        Object obj = ((SortedSet)this.decorated).first();
        this.cacheElement(obj);
        return obj;
    }

    @Override
    public E last() {
        Object obj = ((SortedSet)this.decorated).last();
        this.cacheElement(obj);
        return obj;
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        SortedSet<E> headSet = ((SortedSet)this.decorated).headSet(toElement);
        CacheSortedSetDelegate set = new CacheSortedSetDelegate(this.getCacheSize(), headSet);
        return set;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        SortedSet<E> subSet = ((SortedSet)this.decorated).subSet(fromElement, toElement);
        CacheSortedSetDelegate set = new CacheSortedSetDelegate(this.getCacheSize(), subSet);
        return set;
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        SortedSet<E> headSet = ((SortedSet)this.decorated).tailSet(fromElement);
        CacheSortedSetDelegate set = new CacheSortedSetDelegate(this.getCacheSize(), headSet);
        return set;
    }

    private final class CacheSortedSetDelegate
    extends CacheSortedSet_1x0<E> {
        private CacheSortedSetDelegate(float cacheSize, SortedSet<E> decorateable) {
            super(cacheSize, decorateable);
            this.cache = CacheSortedSet_1x0.this.cache;
        }

        @Override
        public void clear() {
            CacheSortedSet_1x0.this.cacheCounter = 0;
            super.clear();
        }

        @Override
        public boolean contains(Object o) {
            this.cacheCounter = CacheSortedSet_1x0.this.cacheCounter;
            return super.contains(o);
        }
    }
}

