/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.happy.collections.decorators.CacheCollection_1x0;
import org.happy.collections.decorators.EventCollection_1x0;
import org.happy.collections.decorators.UnmodifiableCollection_1x0;
import org.happy.collections.decorators.UnmodifiableStrategy_1x0;
import org.happy.collections.lists.decorators.CacheList_1x0;
import org.happy.collections.lists.decorators.EventList_1x0;
import org.happy.collections.lists.decorators.SortedList_1x0;
import org.happy.collections.lists.decorators.UnmodifiableList_1x0;
import org.happy.collections.maps.DataMap_1x2;
import org.happy.collections.maps.decorators.EventMap_1x2;
import org.happy.collections.maps.decorators.UnmodifiableMap_1x0;
import org.happy.collections.sets.decorators.CacheSet_1x0;
import org.happy.collections.sets.decorators.CacheSortedSet_1x0;
import org.happy.collections.sets.decorators.EventSet_1x0;
import org.happy.collections.sets.decorators.EventSortedSet_1x0;
import org.happy.collections.sets.decorators.UnmodifiableSet_1x0;
import org.happy.collections.sets.decorators.UnmodifiableSortedSet_1x0;
import org.happy.commons.util.Arrays_1x0;
import org.happy.commons.util.comparators.Comparator_1x0;

public class Collections_1x2 {
    private Collections_1x2() {
    }

    public static <E> CacheCollection_1x0<E> cacheCollection(float cacheSize, Collection<E> c) {
        return CacheCollection_1x0.of(cacheSize, c);
    }

    public static <E> EventCollection_1x0<E> eventCollection(Collection<E> c) {
        return EventCollection_1x0.of(c);
    }

    public static <E> UnmodifiableCollection_1x0<E> unmodifiableCollection(Collection<E> decorateable) {
        return UnmodifiableCollection_1x0.of(decorateable, UnmodifiableStrategy_1x0.Unmodifiable);
    }

    public static <E> UnmodifiableCollection_1x0<E> unmodifiableCollection(Collection<E> decorateable, UnmodifiableStrategy_1x0 strategy) {
        return UnmodifiableCollection_1x0.of(decorateable, strategy);
    }

    public static <E> CacheList_1x0<E> cacheList(float cacheSize, List<E> c) {
        return CacheList_1x0.of(cacheSize, c);
    }

    public static <E> EventList_1x0<E> eventList(List<E> list) {
        return EventList_1x0.of(list);
    }

    public static <E> EventList_1x0<E> eventList() {
        return EventList_1x0.of();
    }

    public static <E> SortedList_1x0<E> sortedList(List<E> list, Comparator<E> comparator) {
        return SortedList_1x0.of(list, comparator);
    }

    public static <E> SortedList_1x0<E> sortedList(List<E> list, Comparator<E> comparator, boolean doSort) {
        return SortedList_1x0.of(list, comparator, doSort);
    }

    public static <E> SortedList_1x0<E> sortedList(List<E> list, Comparator<E> comparator, SortedList_1x0.SortType type, boolean inverted, boolean doSort) {
        return SortedList_1x0.of(list, comparator, type, inverted, doSort);
    }

    public static <E> UnmodifiableList_1x0<E> unmodifiableList(List<E> decorateable) {
        return UnmodifiableList_1x0.of(decorateable);
    }

    public static <E> UnmodifiableList_1x0<E> unmodifiableList(List<E> decorateable, UnmodifiableStrategy_1x0 strategy) {
        return UnmodifiableList_1x0.of(decorateable, strategy);
    }

    public static <K, V> EventMap_1x2<K, V> eventMap(Map<K, V> decorated) {
        return EventMap_1x2.of(decorated);
    }

    public static <K, V> UnmodifiableMap_1x0<K, V> unmodifiableMap(Map<K, V> decorateable) {
        return UnmodifiableMap_1x0.of(decorateable, UnmodifiableStrategy_1x0.Unmodifiable);
    }

    public static <K, V> UnmodifiableMap_1x0<K, V> unmodifiableMap(Map<K, V> decorateable, UnmodifiableStrategy_1x0 strategy) {
        return UnmodifiableMap_1x0.of(decorateable, strategy);
    }

    public static <E> CacheSet_1x0<E> cacheSet(float cacheSize, Set<E> c) {
        return CacheSet_1x0.of(cacheSize, c);
    }

    public static <E> EventSet_1x0<E> eventSet(Set<E> set) {
        return EventSet_1x0.of(set);
    }

    public static <E> UnmodifiableSet_1x0<E> unmodifiableSet(Set<E> decorateable) {
        return UnmodifiableSet_1x0.of(decorateable, UnmodifiableStrategy_1x0.Unmodifiable);
    }

    public static <E> UnmodifiableSet_1x0<E> unmodifiableSet(Set<E> decorateable, UnmodifiableStrategy_1x0 strategy) {
        return UnmodifiableSet_1x0.of(decorateable, strategy);
    }

    public static <T extends Comparable<T>> void sort(List<T> list) {
        Collections_1x2.sort(list, new Comparator_1x0());
    }

    public static <T> void sort(List<T> list, Comparator<? super T> c) {
        if (list.isEmpty()) {
            return;
        }
        Object[] x = list.toArray();
        Arrays_1x0.sort(x, c);
        Collections_1x2.replaceContents(list, x);
    }

    private static <T> void replaceContents(List<T> list, T[] a) {
        ListIterator<T> it = list.listIterator();
        int index = 0;
        while (it.hasNext()) {
            it.next();
            it.set(a[index]);
            ++index;
        }
    }

    public static <E> List<E> getElementAt(Collection<E> c, float percentage) {
        if (percentage < 0.0f) {
            throw new IllegalArgumentException("percentage must be bigger as 0.0!");
        }
        if (1.0f < percentage) {
            throw new IllegalArgumentException("percentage must be smaller as 1.0!");
        }
        ArrayList<E> list = new ArrayList<E>();
        list.add(null);
        list.add(null);
        list.add(null);
        int number = (int)((double)((float)c.size() * percentage) + 0.5) - 2;
        Iterator<E> it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            E eins = it.next();
            list.set(1, eins);
            if (number < i) break;
            list.set(0, eins);
            ++i;
        }
        if (it.hasNext()) {
            list.set(2, it.next());
        }
        return list;
    }

    public static <E> CacheSortedSet_1x0<E> cacheSortedSet(float cacheSize, SortedSet<E> set) {
        return CacheSortedSet_1x0.of(cacheSize, set);
    }

    public static <E> EventSortedSet_1x0<E> eventSortedSet(SortedSet<E> set) {
        return EventSortedSet_1x0.of(set);
    }

    public static <E> UnmodifiableSortedSet_1x0<E> unmodifiableSortedSet(SortedSet<E> decorateable) {
        return UnmodifiableSortedSet_1x0.of(decorateable, UnmodifiableStrategy_1x0.Unmodifiable);
    }

    public static <K, V> DataMap_1x2<K, V> dataMap(DataMap_1x2.DataAdapter<K, V> adapter) {
        return DataMap_1x2.of(adapter, 100);
    }
}

