/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Barrier;
import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import EDU.oswego.cs.dl.util.concurrent.WaiterPreferenceSemaphore;

public class Rendezvous
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected int entries_ = 0;
    protected long departures_ = 0L;
    protected final Semaphore entryGate_;
    protected final Object[] slots_;
    protected RendezvousFunction rendezvousFunction_;

    public Rendezvous(int n) {
        this(n, new Rotator());
    }

    public Rendezvous(int n, RendezvousFunction rendezvousFunction) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = n;
        this.rendezvousFunction_ = rendezvousFunction;
        this.entryGate_ = new WaiterPreferenceSemaphore(n);
        this.slots_ = new Object[n];
    }

    public synchronized RendezvousFunction setRendezvousFunction(RendezvousFunction rendezvousFunction) {
        RendezvousFunction rendezvousFunction2 = this.rendezvousFunction_;
        this.rendezvousFunction_ = rendezvousFunction;
        return rendezvousFunction2;
    }

    @Override
    public int parties() {
        return this.parties_;
    }

    @Override
    public synchronized boolean broken() {
        return this.broken_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        while (true) {
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                if (this.entries_ == 0) {
                    this.broken_ = false;
                    return;
                }
                this.notifyAll();
            }
            Thread.yield();
        }
    }

    public Object rendezvous(Object object) throws InterruptedException, BrokenBarrierException {
        return this.doRendezvous(object, false, 0L);
    }

    public Object attemptRendezvous(Object object, long l) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doRendezvous(object, true, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doRendezvous(Object object, boolean bl, long l) throws InterruptedException, TimeoutException, BrokenBarrierException {
        long l2;
        if (bl) {
            l2 = System.currentTimeMillis();
            if (!this.entryGate_.attempt(l)) {
                throw new TimeoutException(l);
            }
        } else {
            l2 = 0L;
            this.entryGate_.acquire();
        }
        Rendezvous rendezvous = this;
        synchronized (rendezvous) {
            int n;
            Object object2;
            block21: {
                block20: {
                    object2 = null;
                    n = this.entries_++;
                    this.slots_[n] = object;
                    try {
                        if (this.entries_ != this.parties_) break block20;
                        this.departures_ = this.entries_;
                        this.notifyAll();
                        try {
                            if (!this.broken_ && this.rendezvousFunction_ != null) {
                                this.rendezvousFunction_.rendezvousFunction(this.slots_);
                            }
                            break block21;
                        }
                        catch (RuntimeException runtimeException) {
                            this.broken_ = true;
                        }
                        break block21;
                    }
                    catch (Throwable throwable) {
                        object2 = this.slots_[n];
                        if (--this.departures_ <= 0L) {
                            for (int i = 0; i < this.slots_.length; ++i) {
                                this.slots_[i] = null;
                            }
                            this.entryGate_.release(this.entries_);
                            this.entries_ = 0;
                        }
                        throw throwable;
                    }
                }
                while (!this.broken_ && this.departures_ < 1L) {
                    long l3 = 0L;
                    if (bl && (l3 = l - (System.currentTimeMillis() - l2)) <= 0L) {
                        this.broken_ = true;
                        this.departures_ = this.entries_;
                        this.notifyAll();
                        throw new TimeoutException(l);
                    }
                    try {
                        this.wait(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.broken_ && this.departures_ <= 0L) {
                            this.broken_ = true;
                            this.departures_ = this.entries_;
                            this.notifyAll();
                            throw interruptedException;
                        }
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
            object2 = this.slots_[n];
            if (--this.departures_ <= 0L) {
                for (int i = 0; i < this.slots_.length; ++i) {
                    this.slots_[i] = null;
                }
                this.entryGate_.release(this.entries_);
                this.entries_ = 0;
            }
            if (this.broken_) {
                throw new BrokenBarrierException(n);
            }
            return object2;
        }
    }

    public static class Rotator
    implements RendezvousFunction {
        @Override
        public void rendezvousFunction(Object[] objectArray) {
            int n = objectArray.length - 1;
            Object object = objectArray[0];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = objectArray[i + 1];
            }
            objectArray[n] = object;
        }
    }

    public static interface RendezvousFunction {
        public void rendezvousFunction(Object[] var1);
    }
}

