/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.duration.Duration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import wvlet.log.Guard;
import wvlet.log.LogLevelScanner$;
import wvlet.log.LogLevelScanner$RUNNING$;
import wvlet.log.LogLevelScanner$STOPPED$;
import wvlet.log.LogLevelScanner$STOPPING$;
import wvlet.log.LogLevelScannerConfig;
import wvlet.log.LogLevelScannerConfig$;

@ScalaSignature(bytes="\u0006\u0001\u0005ux!\u0002\u001a4\u0011\u0003Ad!\u0002\u001e4\u0011\u0003Y\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005b\u0002#\u0002\u0005\u0004%I!\u0012\u0005\u0007\u0013\u0006\u0001\u000b\u0011\u0002$\t\u000b)\u000bA\u0011A&\t\u000fe\u000b!\u0019!C\u00015\"1\u0011.\u0001Q\u0001\nmCQA[\u0001\u0005\u0002-DQA[\u0001\u0005\u00021Da!!\u0002\u0002\t\u0003Y\u0007bCA\u0004\u0003!\u0015\r\u0011\"\u00014\u0003\u0013Aq!!\u0002\u0002\t\u0003\t\t\u000eC\u0004\u0002\u0006\u0005!\t!!6\t\r\u0005\u001d\u0018\u0001\"\u0001l\u0011!\tI/\u0001C\u0001g\u0005-hACA9\u0003A\u0005\u0019\u0013E\u001a\u0002t\u001dA\u0011q_\u0001\t\u0002M\n\tI\u0002\u0005\u0002x\u0005A\taMA=\u0011\u0019\u0011%\u0003\"\u0001\u0002\u0000\u001dA\u0011\u0011`\u0001\t\u0002M\n\tJ\u0002\u0005\u0002\f\u0006A\taMAG\u0011\u0019\u0011U\u0003\"\u0001\u0002\u0010\u001eA\u00111`\u0001\t\u0002M\nII\u0002\u0005\u0002\u0004\u0006A\taMAC\u0011\u0019\u0011\u0005\u0004\"\u0001\u0002\b\u001a1!h\r\u00014\u0003\u001bAaA\u0011\u000e\u0005\u0002\u0005U\u0001\"CA\f5\t\u0007I\u0011BA\r\u0011!\t)D\u0007Q\u0001\n\u0005m\u0001\"CA\u001c5\t\u0007I\u0011BA\u001d\u0011!\t9E\u0007Q\u0001\n\u0005m\u0002BCA%5\t\u0007I\u0011A\u001a\u0002L!A\u00111\u000b\u000e!\u0002\u0013\ti\u0005C\u0004\u0002Vi!\t!a\u0016\t\u000f\u0005e#\u0004\"\u0001\u0002\\!I\u0011q\f\u000eC\u0002\u0013%\u0011\u0011\r\u0005\t\u0003'S\u0002\u0015!\u0003\u0002d!1\u0011Q\u0013\u000e\u0005\u0002-Da!a&\u001b\t\u0003Y\u0007\"CAM5\u0001\u0007I\u0011BAN\u0011%\tIK\u0007a\u0001\n\u0013\tY\u000b\u0003\u0005\u00022j\u0001\u000b\u0015BAO\u0011%\t\u0019L\u0007a\u0001\n\u0013\tY\nC\u0005\u00026j\u0001\r\u0011\"\u0003\u00028\"A\u00111\u0018\u000e!B\u0013\ti\n\u0003\u0004\u0002>j!Ia\u001b\u0004\u0007\u0003\u007fSB!!1\t\r\t{C\u0011AAe\u0011\u001d\til\fC!\u0003\u001f\fq\u0002T8h\u0019\u00164X\r\\*dC:tWM\u001d\u0006\u0003iU\n1\u0001\\8h\u0015\u00051\u0014!B<wY\u0016$8\u0001\u0001\t\u0003s\u0005i\u0011a\r\u0002\u0010\u0019><G*\u001a<fYN\u001b\u0017M\u001c8feN\u0011\u0011\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0014A\u00027pO\u001e,'/F\u0001G!\tIt)\u0003\u0002Ig\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u0007tKRdun\u001a'fm\u0016d7\u000f\u0006\u0002M\u001fB\u0011Q(T\u0005\u0003\u001dz\u0012A!\u00168ji\")\u0001+\u0002a\u0001#\u0006!a-\u001b7f!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0002j_*\ta+\u0001\u0003kCZ\f\u0017B\u0001-T\u0005\u00111\u0015\u000e\\3\u0002A\u0011+e)Q+M)~cuj\u0012'F-\u0016cuLR%M\u000b~\u001b\u0015I\u0014#J\t\u0006#ViU\u000b\u00027B\u0019A,Y2\u000e\u0003uS!AX0\u0002\u0013%lW.\u001e;bE2,'B\u00011?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Ev\u0013A\u0001T5tiB\u0011AmZ\u0007\u0002K*\u0011a-V\u0001\u0005Y\u0006tw-\u0003\u0002iK\n11\u000b\u001e:j]\u001e\f\u0011\u0005R#G\u0003VcEk\u0018'P\u000f2+e+\u0012'`\r&cUiX\"B\u001d\u0012KE)\u0011+F'\u0002\nQb]2b]2{w\rT3wK2\u001cX#\u0001'\u0015\u00051k\u0007\"\u00028\n\u0001\u0004y\u0017A\u00067pO2,g/\u001a7GS2,7)\u00198eS\u0012\fG/Z:\u0011\u0007AD8P\u0004\u0002rm:\u0011!/^\u0007\u0002g*\u0011AoN\u0001\u0007yI|w\u000e\u001e \n\u0003}J!a\u001e \u0002\u000fA\f7m[1hK&\u0011\u0011P\u001f\u0002\u0004'\u0016\f(BA<?!\ra\u0018\u0011\u0001\b\u0003{z\u0004\"A\u001d \n\u0005}t\u0014A\u0002)sK\u0012,g-C\u0002i\u0003\u0007Q!a  \u0002)M\u001c\u0007.\u001a3vY\u0016dun\u001a'fm\u0016d7kY1o\u0003=awn\u001a'fm\u0016d7kY1o]\u0016\u0014XCAA\u0006!\tI$d\u0005\u0003\u001by\u0005=\u0001cA\u001d\u0002\u0012%\u0019\u00111C\u001a\u0003\u000b\u001d+\u0018M\u001d3\u0015\u0005\u0005-\u0011AB2p]\u001aLw-\u0006\u0002\u0002\u001cA1\u0011QDA\u0016\u0003_i!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0007CR|W.[2\u000b\t\u0005\u0015\u0012qE\u0001\u000bG>t7-\u001e:sK:$(bAA\u0015+\u0006!Q\u000f^5m\u0013\u0011\ti#a\b\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u00042!OA\u0019\u0013\r\t\u0019d\r\u0002\u0016\u0019><G*\u001a<fYN\u001b\u0017M\u001c8fe\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nQbY8oM&<7\t[1oO\u0016$WCAA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"\u0002BA!\u0003G\tQ\u0001\\8dWNLA!!\u0012\u0002@\tI1i\u001c8eSRLwN\\\u0001\u000fG>tg-[4DQ\u0006tw-\u001a3!\u0003%\u00198-\u00198D_VtG/\u0006\u0002\u0002NA!\u0011QDA(\u0013\u0011\t\t&a\b\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\u0006tG\u0006t7i\\;oi\u0002\n\u0011bZ3u\u0007>tg-[4\u0016\u0005\u0005=\u0012!C:fi\u000e{gNZ5h)\ra\u0015Q\f\u0005\b\u0003/\u0019\u0003\u0019AA\u0018\u0003\u0015\u0019H/\u0019;f+\t\t\u0019\u0007\u0005\u0004\u0002\u001e\u0005-\u0012Q\r\t\u0004\u0003O\u0002bbAA5\u00019!\u00111NA8\u001d\r\u0011\u0018QN\u0005\u0002m%\u0011A'\u000e\u0002\r'\u000e\fgN\\3s'R\fG/Z\n\u0003!qJC\u0001\u0005\n\u0019+\t9!+\u0016(O\u0013:;5\u0003\u0002\n=\u0003w\u00022!! \u0011\u001b\u0005\tACAAA!\r\tiH\u0005\u0002\b'R{\u0005\u000bU#E'\u0011AB(a\u001f\u0015\u0005\u0005%\u0005cAA?1\tA1\u000bV(Q!&sui\u0005\u0003\u0016y\u0005mDCAAI!\r\ti(F\u0001\u0007gR\fG/\u001a\u0011\u0002\u000bM$\u0018M\u001d;\u0002\tM$x\u000e]\u0001\u0014Y\u0006\u001cHoU2iK\u0012,H.\u001a3NS2d\u0017n]\u000b\u0003\u0003;\u0003R!PAP\u0003GK1!!)?\u0005\u0019y\u0005\u000f^5p]B\u0019Q(!*\n\u0007\u0005\u001dfH\u0001\u0003M_:<\u0017a\u00067bgR\u001c6\r[3ek2,G-T5mY&\u001cx\fJ3r)\ra\u0015Q\u0016\u0005\n\u0003_K\u0013\u0011!a\u0001\u0003;\u000b1\u0001\u001f\u00132\u0003Qa\u0017m\u001d;TG\",G-\u001e7fI6KG\u000e\\5tA\u0005\tB.Y:u'\u000e\fgN\\3e\u001b&dG.[:\u0002+1\f7\u000f^*dC:tW\rZ'jY2L7o\u0018\u0013fcR\u0019A*!/\t\u0013\u0005=F&!AA\u0002\u0005u\u0015A\u00057bgR\u001c6-\u00198oK\u0012l\u0015\u000e\u001c7jg\u0002\n1A];o\u0005Uaun\u001a'fm\u0016d7kY1o]\u0016\u0014H\u000b\u001b:fC\u0012\u001c2aLAb!\r!\u0017QY\u0005\u0004\u0003\u000f,'A\u0002+ie\u0016\fG\r\u0006\u0002\u0002LB\u0019\u0011QZ\u0018\u000e\u0003i!\u0012\u0001\u0014\u000b\u0004\u0019\u0006M\u0007bBA\f\u0019\u0001\u0007\u0011q\u0006\u000b\u0004\u0019\u0006]\u0007bBAm\u001b\u0001\u0007\u00111\\\u0001\tIV\u0014\u0018\r^5p]B!\u0011Q\\Ar\u001b\t\tyN\u0003\u0003\u0002Z\u0006\u0005(bAA\u0013}%!\u0011Q]Ap\u0005!!UO]1uS>t\u0017!G:u_B\u001c6\r[3ek2,G\rT8h\u0019\u00164X\r\\*dC:\fAa]2b]R1\u0011QTAw\u0003kDq!a<\u0010\u0001\u0004\t\t0\u0001\fm_\u001edUM^3m\r&dWmQ1oI&$\u0017\r^3t!\u0011\u0001\u00181_>\n\u0005\tT\bbBAZ\u001f\u0001\u0007\u0011QT\u0001\b%Vse*\u0013(H\u0003!\u0019Fk\u0014)Q\u0013:;\u0015aB*U\u001fB\u0003V\t\u0012")
public class LogLevelScanner
implements Guard {
    private final AtomicReference<LogLevelScannerConfig> config;
    private final Condition configChanged;
    private final AtomicLong scanCount;
    private final AtomicReference<ScannerState> state;
    private Option<Object> lastScheduledMillis;
    private Option<Object> lastScannedMillis;
    private final ReentrantLock wvlet$log$Guard$$lock;

    public static void stopScheduledLogLevelScan() {
        LogLevelScanner$.MODULE$.stopScheduledLogLevelScan();
    }

    public static void scheduleLogLevelScan(Duration duration) {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan(duration);
    }

    public static void scheduleLogLevelScan(LogLevelScannerConfig logLevelScannerConfig) {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan(logLevelScannerConfig);
    }

    public static void scheduleLogLevelScan() {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan();
    }

    public static void scanLogLevels(Seq<String> seq) {
        LogLevelScanner$.MODULE$.scanLogLevels(seq);
    }

    public static void scanLogLevels() {
        LogLevelScanner$.MODULE$.scanLogLevels();
    }

    public static List<String> DEFAULT_LOGLEVEL_FILE_CANDIDATES() {
        return LogLevelScanner$.MODULE$.DEFAULT_LOGLEVEL_FILE_CANDIDATES();
    }

    public static void setLogLevels(File file) {
        LogLevelScanner$.MODULE$.setLogLevels(file);
    }

    @Override
    public Condition newCondition() {
        return Guard.newCondition$(this);
    }

    @Override
    public <U> U guard(Function0<U> body) {
        return (U)Guard.guard$(this, body);
    }

    @Override
    public ReentrantLock wvlet$log$Guard$$lock() {
        return this.wvlet$log$Guard$$lock;
    }

    @Override
    public final void wvlet$log$Guard$_setter_$wvlet$log$Guard$$lock_$eq(ReentrantLock x$1) {
        this.wvlet$log$Guard$$lock = x$1;
    }

    private AtomicReference<LogLevelScannerConfig> config() {
        return this.config;
    }

    private Condition configChanged() {
        return this.configChanged;
    }

    public AtomicLong scanCount() {
        return this.scanCount;
    }

    public LogLevelScannerConfig getConfig() {
        return this.config().get();
    }

    public void setConfig(LogLevelScannerConfig config) {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogLevelScannerConfig prev = this.config().get();
            List<String> list = prev.logLevelFileCandidates();
            List<String> list2 = config.logLevelFileCandidates();
            if (list == null ? list2 != null : !list.equals(list2)) {
                this.lastScannedMillis_$eq((Option<Object>)None$.MODULE$);
            }
            this.config().set(config);
            this.configChanged().signalAll();
        });
    }

    private AtomicReference<ScannerState> state() {
        return this.state;
    }

    public void start() {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                this.state().compareAndSet(LogLevelScanner$STOPPING$.MODULE$, LogLevelScanner$RUNNING$.MODULE$);
                if (!this.state().compareAndSet(LogLevelScanner$STOPPED$.MODULE$, LogLevelScanner$RUNNING$.MODULE$)) break block0;
                new LogLevelScannerThread().start();
            }
        });
    }

    public void stop() {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.state().set(LogLevelScanner$STOPPING$.MODULE$));
    }

    private Option<Object> lastScheduledMillis() {
        return this.lastScheduledMillis;
    }

    private void lastScheduledMillis_$eq(Option<Object> x$1) {
        this.lastScheduledMillis = x$1;
    }

    private Option<Object> lastScannedMillis() {
        return this.lastScannedMillis;
    }

    private void lastScannedMillis_$eq(Option<Object> x$1) {
        this.lastScannedMillis = x$1;
    }

    public void wvlet$log$LogLevelScanner$$run() {
        while (!this.state().compareAndSet(LogLevelScanner$STOPPING$.MODULE$, LogLevelScanner$STOPPED$.MODULE$)) {
            long currentTimeMillis = System.currentTimeMillis();
            long scanIntervalMillis = this.getConfig().scanInterval().toMillis();
            if (this.lastScheduledMillis().isEmpty() || currentTimeMillis - BoxesRunTime.unboxToLong((Object)this.lastScheduledMillis().get()) > scanIntervalMillis) {
                Option<Object> updatedLastScannedMillis = LogLevelScanner$.MODULE$.scan(this.getConfig().logLevelFileCandidates(), this.lastScannedMillis());
                this.scanCount().incrementAndGet();
                this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lastScannedMillis_$eq(updatedLastScannedMillis));
                this.lastScheduledMillis_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)currentTimeMillis)));
            }
            long sleepTime = scanIntervalMillis - package$.MODULE$.max(0L, package$.MODULE$.min(scanIntervalMillis, currentTimeMillis - BoxesRunTime.unboxToLong((Object)this.lastScheduledMillis().get())));
            this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (!this.configChanged().await(sleepTime, TimeUnit.MILLISECONDS)) {
                    // empty if block
                }
            });
        }
    }

    public LogLevelScanner() {
        Guard.$init$(this);
        this.config = new AtomicReference<LogLevelScannerConfig>(new LogLevelScannerConfig((List<String>)List$.MODULE$.empty(), LogLevelScannerConfig$.MODULE$.apply$default$2()));
        this.configChanged = this.newCondition();
        this.scanCount = new AtomicLong(0L);
        this.state = new AtomicReference<LogLevelScanner$STOPPED$>(LogLevelScanner$STOPPED$.MODULE$);
        this.lastScheduledMillis = None$.MODULE$;
        this.lastScannedMillis = None$.MODULE$;
    }

    public class LogLevelScannerThread
    extends Thread {
        @Override
        public void run() {
            this.wvlet$log$LogLevelScanner$LogLevelScannerThread$$$outer().wvlet$log$LogLevelScanner$$run();
        }

        public /* synthetic */ LogLevelScanner wvlet$log$LogLevelScanner$LogLevelScannerThread$$$outer() {
            return LogLevelScanner.this;
        }

        public LogLevelScannerThread() {
            if (LogLevelScanner.this == null) {
                throw null;
            }
            this.setName("AirframeLogLevelScanner");
            this.setDaemon(true);
        }
    }

    public static interface ScannerState {
    }
}

