/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.komamitsu.fluency.BufferFullException;
import org.komamitsu.fluency.EventTime;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.flusher.Flusher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fluency
implements Flushable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Fluency.class);
    private final Buffer buffer;
    private final Flusher flusher;
    private final Emitter emitter = new Emitter();

    public Fluency(Buffer buffer, Flusher flusher) {
        this.buffer = buffer;
        this.flusher = flusher;
    }

    public void emit(String tag, long timestamp, Map<String, Object> data) throws IOException {
        this.emitter.emit(() -> this.buffer.append(tag, timestamp, data));
    }

    public void emit(String tag, Map<String, Object> data) throws IOException {
        this.emit(tag, System.currentTimeMillis() / 1000L, data);
    }

    public void emit(String tag, EventTime eventTime, Map<String, Object> data) throws IOException {
        this.emitter.emit(() -> this.buffer.append(tag, eventTime, data));
    }

    public void emit(String tag, long timestamp, byte[] mapValue, int offset, int len) throws IOException {
        this.emitter.emit(() -> this.buffer.appendMessagePackMapValue(tag, timestamp, mapValue, offset, len));
    }

    public void emit(String tag, byte[] mapValue, int offset, int len) throws IOException {
        this.emit(tag, System.currentTimeMillis() / 1000L, mapValue, offset, len);
    }

    public void emit(String tag, EventTime eventTime, byte[] mapValue, int offset, int len) throws IOException {
        this.emitter.emit(() -> this.buffer.appendMessagePackMapValue(tag, eventTime, mapValue, offset, len));
    }

    public void emit(String tag, long timestamp, ByteBuffer mapValue) throws IOException {
        this.emitter.emit(() -> this.buffer.appendMessagePackMapValue(tag, timestamp, mapValue));
    }

    public void emit(String tag, ByteBuffer mapValue) throws IOException {
        this.emit(tag, System.currentTimeMillis() / 1000L, mapValue);
    }

    public void emit(String tag, EventTime eventTime, ByteBuffer mapValue) throws IOException {
        this.emitter.emit(() -> this.buffer.appendMessagePackMapValue(tag, eventTime, mapValue));
    }

    @Override
    public void flush() throws IOException {
        this.flusher.flush();
    }

    @Override
    public void close() throws IOException {
        this.flusher.close();
    }

    public void clearBackupFiles() {
        this.buffer.clearBackupFiles();
    }

    public long getAllocatedBufferSize() {
        return this.buffer.getAllocatedSize();
    }

    public long getBufferedDataSize() {
        return this.buffer.getBufferedDataSize();
    }

    public boolean isTerminated() {
        return this.flusher.isTerminated();
    }

    public boolean waitUntilAllBufferFlushed(int maxWaitSeconds) throws InterruptedException {
        int intervalMilli = 500;
        for (int i = 0; i < maxWaitSeconds * (1000 / intervalMilli); ++i) {
            long bufferedDataSize = this.getBufferedDataSize();
            LOG.debug("Waiting for flushing all buffer: {}", (Object)bufferedDataSize);
            if (bufferedDataSize == 0L) {
                return true;
            }
            TimeUnit.MILLISECONDS.sleep(intervalMilli);
        }
        LOG.warn("Buffered data still remains: {}", (Object)this.getBufferedDataSize());
        return false;
    }

    public boolean waitUntilFlusherTerminated(int maxWaitSeconds) throws InterruptedException {
        int intervalMilli = 500;
        for (int i = 0; i < maxWaitSeconds * (1000 / intervalMilli); ++i) {
            boolean terminated = this.isTerminated();
            LOG.debug("Waiting until the flusher is terminated: {}", (Object)terminated);
            if (terminated) {
                return true;
            }
            TimeUnit.MILLISECONDS.sleep(intervalMilli);
        }
        LOG.warn("The flusher isn't terminated");
        return false;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public Flusher getFlusher() {
        return this.flusher;
    }

    public String toString() {
        return "Fluency{buffer=" + this.buffer + ", flusher=" + this.flusher + '}';
    }

    private class Emitter {
        private Emitter() {
        }

        void emit(Append appender) throws IOException {
            try {
                appender.append();
            }
            catch (BufferFullException e) {
                LOG.error("emit() failed due to buffer full. Flushing buffer. Please try again...");
                Fluency.this.flusher.flush();
                throw e;
            }
        }
    }

    private static interface Append {
        public void append() throws IOException;
    }
}

