/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.okhttp3;

import io.prestosql.jdbc.$internal.javax.annotation.Nullable;
import io.prestosql.jdbc.$internal.okhttp3.internal.Util;
import java.nio.charset.Charset;

public final class Challenge {
    private final String scheme;
    private final String realm;
    private final Charset charset;

    public Challenge(String scheme, String realm) {
        this(scheme, realm, Util.ISO_8859_1);
    }

    private Challenge(String scheme, String realm, Charset charset) {
        if (scheme == null) {
            throw new NullPointerException("scheme == null");
        }
        if (realm == null) {
            throw new NullPointerException("realm == null");
        }
        if (charset == null) {
            throw new NullPointerException("charset == null");
        }
        this.scheme = scheme;
        this.realm = realm;
        this.charset = charset;
    }

    public Challenge withCharset(Charset charset) {
        return new Challenge(this.scheme, this.realm, charset);
    }

    public String scheme() {
        return this.scheme;
    }

    public String realm() {
        return this.realm;
    }

    public Charset charset() {
        return this.charset;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Challenge && ((Challenge)other).scheme.equals(this.scheme) && ((Challenge)other).realm.equals(this.realm) && ((Challenge)other).charset.equals(this.charset);
    }

    public int hashCode() {
        int result = 29;
        result = 31 * result + this.realm.hashCode();
        result = 31 * result + this.scheme.hashCode();
        result = 31 * result + this.charset.hashCode();
        return result;
    }

    public String toString() {
        return this.scheme + " realm=\"" + this.realm + "\" charset=\"" + this.charset + "\"";
    }
}

