/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.spark.thirdparty.okhttp3;

import com.treasuredata.spark.thirdparty.okhttp3.Cookie;
import com.treasuredata.spark.thirdparty.okhttp3.CookieJar;
import com.treasuredata.spark.thirdparty.okhttp3.HttpUrl;
import com.treasuredata.spark.thirdparty.okhttp3.internal.Util;
import com.treasuredata.spark.thirdparty.okhttp3.internal.platform.Platform;
import java.io.IOException;
import java.net.CookieHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class JavaNetCookieJar
implements CookieJar {
    private final CookieHandler cookieHandler;

    public JavaNetCookieJar(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    @Override
    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        if (this.cookieHandler != null) {
            ArrayList<String> cookieStrings = new ArrayList<String>();
            for (Cookie cookie : cookies) {
                cookieStrings.add(cookie.toString(true));
            }
            Map<String, List<String>> multimap = Collections.singletonMap("Set-Cookie", cookieStrings);
            try {
                this.cookieHandler.put(url.uri(), multimap);
            }
            catch (IOException e) {
                Platform.get().log(5, "Saving cookies failed for " + url.resolve("/..."), e);
            }
        }
    }

    @Override
    public List<Cookie> loadForRequest(HttpUrl url) {
        Map<String, List<String>> cookieHeaders;
        Map<String, List<String>> headers = Collections.emptyMap();
        try {
            cookieHeaders = this.cookieHandler.get(url.uri(), headers);
        }
        catch (IOException e) {
            Platform.get().log(5, "Loading cookies failed for " + url.resolve("/..."), e);
            return Collections.emptyList();
        }
        ArrayList<Cookie> cookies = null;
        for (Map.Entry<String, List<String>> entry : cookieHeaders.entrySet()) {
            String key = entry.getKey();
            if (!"Cookie".equalsIgnoreCase(key) && !"Cookie2".equalsIgnoreCase(key) || entry.getValue().isEmpty()) continue;
            for (String header : entry.getValue()) {
                if (cookies == null) {
                    cookies = new ArrayList<Cookie>();
                }
                cookies.addAll(this.decodeHeaderAsJavaNetCookies(url, header));
            }
        }
        return cookies != null ? Collections.unmodifiableList(cookies) : Collections.emptyList();
    }

    private List<Cookie> decodeHeaderAsJavaNetCookies(HttpUrl url, String header) {
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        int pos = 0;
        int limit = header.length();
        while (pos < limit) {
            int pairEnd = Util.delimiterOffset(header, pos, limit, ";,");
            int equalsSign = Util.delimiterOffset(header, pos, pairEnd, '=');
            String name = Util.trimSubstring(header, pos, equalsSign);
            if (!name.startsWith("$")) {
                String value;
                String string = value = equalsSign < pairEnd ? Util.trimSubstring(header, equalsSign + 1, pairEnd) : "";
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                result.add(new Cookie.Builder().name(name).value(value).domain(url.host()).build());
            }
            pos = pairEnd + 1;
        }
        return result;
    }
}

