/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.spark;

import com.treasuredata.client.TDClient;
import com.treasuredata.client.model.TDColumn;
import com.treasuredata.client.model.TDColumnType;
import com.treasuredata.client.model.TDTableDistribution;
import com.treasuredata.partition.bucket.BucketColumnType;
import com.treasuredata.partition.bucket.HashBucketFunction;
import com.treasuredata.partition.bucket.RowHashBucketFunction;
import com.treasuredata.spark.TDPartitioner;
import com.treasuredata.spark.TDSparkErrorCode;
import com.treasuredata.spark.TDSparkException;
import com.treasuredata.spark.TDTableName;
import com.treasuredata.spark.TDWriterConfig;
import com.treasuredata.spark.thirdparty.com.google.common.base.Optional;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.KeyValueGroupedDataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel$DEBUG$;
import wvlet.log.LogLevel$TRACE$;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class TDPartitioner$
implements LogSupport {
    public static TDPartitioner$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new TDPartitioner$();
    }

    private Logger logger$lzycompute() {
        TDPartitioner$ tDPartitioner$ = this;
        synchronized (tDPartitioner$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Dataset<Row> partitionByTime(Dataset<Row> dataFrame, TDWriterConfig config) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        boolean hasTimeColumn = dataFrame.schema().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TDPartitioner$.$anonfun$partitionByTime$1(x$1)));
        if (this.logger().isEnabled(LogLevel$TRACE$.MODULE$)) {
            this.logger().log(LogLevel$TRACE$.MODULE$, new LogSource("/Users/leo/work/git/td-spark/td-spark/src/main/scala/com/treasuredata/spark/TDPartitioner.scala", "TDPartitioner.scala", 29, 10), new StringBuilder(17).append("has time column? ").append(hasTimeColumn).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long rowCount = dataFrame.count();
        int uploadPartitionCount = Math.max((int)(rowCount / config.maxRowCountPerPartition()), 1);
        if (this.logger().isEnabled(LogLevel$DEBUG$.MODULE$)) {
            long arg$macro$1 = rowCount;
            int arg$macro$2 = uploadPartitionCount;
            this.logger().log(LogLevel$DEBUG$.MODULE$, new LogSource("/Users/leo/work/git/td-spark/td-spark/src/main/scala/com/treasuredata/spark/TDPartitioner.scala", "TDPartitioner.scala", 37, 10), new StringOps("The dataframe has %,d rows. Will create %,d partitions").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), BoxesRunTime.boxToInteger((int)arg$macro$2)})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return hasTimeColumn ? dataFrame.repartitionByRange(uploadPartitionCount, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{new Column("time")})) : dataFrame.repartition(uploadPartitionCount);
    }

    public Tuple2<Seq<TDColumn>, RowHashBucketFunction> newRowWiseBucketFunction(TDPartitioner.UDPKeys udpKeys, TDTableName table) {
        Seq bucketFunctionTypes = (Seq)udpKeys.partitionColumns().map((Function1 & Serializable & scala.Serializable)c -> MODULE$.toBucketColumnType(c.getType()), Seq$.MODULE$.canBuildFrom());
        return new Tuple2(udpKeys.partitionColumns(), (Object)new RowHashBucketFunction(udpKeys.bucketCount(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(bucketFunctionTypes).asJava()));
    }

    public Tuple2<Seq<TDColumnType>, HashBucketFunction> newColumnWiseBucketFunction(TDPartitioner.UDPKeys udpKeys, Seq<TDColumnType> types) {
        Seq bucketFunctionTypes = (Seq)types.map((Function1 & Serializable & scala.Serializable)tdColumnType -> MODULE$.toBucketColumnType((TDColumnType)tdColumnType), Seq$.MODULE$.canBuildFrom());
        return new Tuple2(types, (Object)new HashBucketFunction(udpKeys.bucketCount(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(bucketFunctionTypes).asJava()));
    }

    private BucketColumnType toBucketColumnType(TDColumnType tdColumnType) {
        BucketColumnType bucketColumnType;
        TDColumnType tDColumnType = tdColumnType;
        TDColumnType tDColumnType2 = TDColumnType.INT;
        TDColumnType tDColumnType3 = tDColumnType;
        if (!(tDColumnType2 != null ? !((Object)tDColumnType2).equals(tDColumnType3) : tDColumnType3 != null)) {
            bucketColumnType = BucketColumnType.INTEGER;
        } else {
            TDColumnType tDColumnType4 = TDColumnType.LONG;
            TDColumnType tDColumnType5 = tDColumnType;
            if (!(tDColumnType4 != null ? !((Object)tDColumnType4).equals(tDColumnType5) : tDColumnType5 != null)) {
                bucketColumnType = BucketColumnType.INTEGER;
            } else {
                TDColumnType tDColumnType6 = TDColumnType.STRING;
                TDColumnType tDColumnType7 = tDColumnType;
                if (!(tDColumnType6 != null ? !((Object)tDColumnType6).equals(tDColumnType7) : tDColumnType7 != null)) {
                    bucketColumnType = BucketColumnType.STRING;
                } else {
                    throw new TDSparkException(TDSparkErrorCode.INVALID_PARTITIONING_COLUMN, new StringBuilder(39).append("Invalid partition column is specified: ").append(tdColumnType).toString());
                }
            }
        }
        return bucketColumnType;
    }

    public Option<TDPartitioner.UDPKeys> getUDPKeys(TDClient tdClient, TDTableName table) {
        None$ none$;
        Optional<TDTableDistribution> opt = tdClient.tableDistribution(table.db(), table.table());
        if (opt.isPresent()) {
            TDTableDistribution d = opt.get();
            none$ = new Some((Object)new TDPartitioner.UDPKeys(d.getPartitionFunction(), (Seq<TDColumn>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(d.getColumns()).asScala()), (int)d.getBucketCount()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public KeyValueGroupedDataset<Object, Row> partitionByBucketingKeys(Dataset<Row> dataFrame, TDWriterConfig config, TDTableName table, TDPartitioner.UDPKeys udpKeys) {
        StructType schema = dataFrame.schema();
        return dataFrame.groupByKey((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)TDPartitioner$.$anonfun$partitionByBucketingKeys$1(udpKeys, table, schema, row)), dataFrame.sparkSession().implicits().newIntEncoder());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$partitionByTime$1(StructField x$1) {
        String string = x$1.name();
        String string2 = "time";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$partitionByBucketingKeys$1(TDPartitioner.UDPKeys udpKeys$1, TDTableName table$1, StructType schema$1, Row row) {
        Tuple2<Seq<TDColumn>, RowHashBucketFunction> tuple2 = MODULE$.newRowWiseBucketFunction(udpKeys$1, table$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq partitionColumns = (Seq)tuple2._1();
        RowHashBucketFunction rowHashBucketFunction = (RowHashBucketFunction)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionColumns, (Object)rowHashBucketFunction);
        Tuple2 tuple23 = tuple22;
        Seq partitionColumns2 = (Seq)tuple23._1();
        RowHashBucketFunction rowHashBucketFunction2 = (RowHashBucketFunction)tuple23._2();
        Seq partitionKeys = (Seq)partitionColumns2.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Seq$.MODULE$.canBuildFrom());
        Seq partitionIndices = (Seq)((TraversableLike)((TraversableLike)schema$1.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)s2 -> BoxesRunTime.boxToBoolean((boolean)partitionKeys.contains((Object)((StructField)s2._1()).name())))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4._2$mcI$sp()), Seq$.MODULE$.canBuildFrom());
        return rowHashBucketFunction2.getBucket(new TDPartitioner.DataFrameRow(row), (int[])partitionIndices.toArray(ClassTag$.MODULE$.Int()));
    }

    private TDPartitioner$() {
        MODULE$ = this;
        LoggingMethods.$init$(this);
        LazyLogger.$init$(this);
    }
}

