/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.writer.sparse;

import com.treasuredata.partition.mpc.writer.sparse.IncrementalIntVector;
import com.treasuredata.partition.mpc.writer.sparse.MappedValueVector;
import com.treasuredata.partition.mpc.writer.sparse.PositiveIntVector;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.msgpack.value.Value;

public class SparseTableBuilder
implements Closeable {
    private IncrementalIntVector rowVec = new IncrementalIntVector();
    private PositiveIntVector colVec = new PositiveIntVector();
    private MappedValueVector valVec;

    public SparseTableBuilder(File file) throws IOException {
        this.valVec = new MappedValueVector(file);
    }

    public void add(long l, int n, Value value) throws IOException {
        this.rowVec.add(l);
        this.colVec.add(n);
        this.valVec.write(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(int n, ExtractCallback extractCallback) throws IOException {
        IncrementalIntVector.Iterator iterator = this.rowVec.iterator();
        PositiveIntVector.Iterator iterator2 = this.colVec.iterator();
        try (MappedValueVector.Reader reader = this.valVec.openReader();){
            while (iterator2.hasNext()) {
                long l = iterator.next();
                int n2 = iterator2.next();
                if (n2 == n) {
                    Value value = reader.read();
                    extractCallback.call(l, value);
                    continue;
                }
                reader.skip();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.valVec.close();
    }

    public static interface ExtractCallback {
        public void call(long var1, Value var3) throws IOException;
    }
}

