/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.writer.sparse;

import java.util.Arrays;
import java.util.NoSuchElementException;

public class PositiveIntVector {
    private byte[] data = new byte[1024];
    private int filled;

    public void add(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Integer can't be negative");
        }
        this.ensureWritableSize();
        int n2 = this.filled;
        while (true) {
            int n3;
            if ((n3 = n >> 7) == 0) break;
            this.data[this.filled++] = (byte)(n & 0x7F);
            n = n3;
        }
        this.data[this.filled++] = (byte)(n | 0x80);
    }

    private void ensureWritableSize() {
        if (this.data.length < this.filled + 5) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator {
        private int pos = 0;

        public boolean hasNext() {
            return PositiveIntVector.this.filled > this.pos;
        }

        public int next() {
            byte by;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = 0;
            int n2 = 0;
            while ((by = PositiveIntVector.this.data[this.pos++]) >= 0) {
                n += by << n2;
                n2 += 7;
            }
            return n += (by & 0x7F) << n2;
        }

        public void skip() {
            this.next();
        }
    }
}

