/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.writer.sparse;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;

public class MappedValueVector
implements Closeable {
    private final File tempfile;
    private final OutputStream in;
    private final MessagePacker packer;

    public MappedValueVector(File file) throws IOException {
        this.tempfile = file;
        this.in = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        this.packer = MessagePack.newDefaultPacker(this.in);
    }

    public void write(Value value) throws IOException {
        this.packer.packValue(value);
    }

    public Reader openReader() throws IOException {
        this.packer.flush();
        this.in.flush();
        return new Reader();
    }

    @Override
    public void close() throws IOException {
        this.packer.close();
        this.tempfile.delete();
    }

    public class Reader {
        private final MessageUnpacker u;

        public Reader() throws IOException {
            this.u = MessagePack.newDefaultUnpacker(Files.newInputStream(MappedValueVector.this.tempfile.toPath(), new OpenOption[0]));
        }

        public Value read() throws IOException {
            if (this.u.hasNext()) {
                return this.u.unpackValue();
            }
            throw new EOFException("No more data");
        }

        public void skip() throws IOException {
            if (!this.u.hasNext()) {
                throw new EOFException("No more data to skip");
            }
            this.u.skipValue();
        }

        public void close() throws IOException {
            this.u.close();
        }
    }
}

