/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.writer.sparse;

import com.treasuredata.partition.mpc.writer.sparse.PositiveIntVector;

public class IncrementalIntVector {
    private final long firstValue;
    private long lastValue;
    private PositiveIntVector vec;

    public IncrementalIntVector() {
        this(0L);
    }

    public IncrementalIntVector(long l) {
        this.firstValue = l;
        this.lastValue = l;
        this.vec = new PositiveIntVector();
    }

    public void add(long l) {
        long l2 = l - this.lastValue;
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Increment is not within [0, INT_MAX]");
        }
        this.vec.add((int)l2);
        this.lastValue += l2;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator {
        private PositiveIntVector.Iterator vecit;
        private long lastValue;

        public Iterator() {
            this.vecit = IncrementalIntVector.this.vec.iterator();
            this.lastValue = IncrementalIntVector.this.firstValue;
        }

        public boolean hasNext() {
            return this.vecit.hasNext();
        }

        public long next() {
            int n = this.vecit.next();
            this.lastValue += (long)n;
            return this.lastValue;
        }

        public void skip() {
            this.next();
        }
    }
}

