/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import com.treasuredata.partition.mpc.reader.columnar.AbstractColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueHolder;
import java.io.IOException;
import org.msgpack.core.MessageIntegerOverflowException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueType;

public class BooleanColumnReader
extends AbstractColumnReader {
    private final BooleanHolder holder = new BooleanHolder();

    public BooleanColumnReader(MessageUnpacker messageUnpacker) {
        super(messageUnpacker);
    }

    @Override
    protected BooleanHolder current() {
        return this.holder;
    }

    @Override
    public boolean getBoolean() throws IOException {
        return this.holder.getOrElseUpdate();
    }

    @Override
    public Value getValue() throws IOException {
        if (this.isNull()) {
            return ValueFactory.newNil();
        }
        return ValueFactory.newBoolean(this.getBoolean());
    }

    private class BooleanHolder
    extends ColumnValueHolder {
        private boolean value;

        private BooleanHolder() {
        }

        @Override
        public boolean update() throws IOException {
            if (!this.isRead) {
                ValueType valueType = BooleanColumnReader.this.unpacker.getNextFormat().getValueType();
                switch (valueType) {
                    case BOOLEAN: {
                        this.value = BooleanColumnReader.this.unpacker.unpackBoolean();
                        break;
                    }
                    case STRING: {
                        this.value = Boolean.parseBoolean(BooleanColumnReader.this.unpacker.unpackString());
                        break;
                    }
                    case INTEGER: {
                        try {
                            this.value = BooleanColumnReader.this.unpacker.unpackLong() != 0L;
                        }
                        catch (MessageIntegerOverflowException messageIntegerOverflowException) {
                            this.isValid = false;
                        }
                        break;
                    }
                    case NIL: {
                        this.isValid = false;
                        BooleanColumnReader.this.unpacker.skipValue();
                        break;
                    }
                    default: {
                        this.isValid = false;
                        BooleanColumnReader.this.unpacker.skipValue();
                    }
                }
                this.isRead = true;
            }
            return this.isValid;
        }

        public boolean getOrElseUpdate() throws IOException {
            this.update();
            return this.value;
        }
    }
}

