/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.filter;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.buffer.BufferUtil;
import com.treasuredata.partition.mpc.buffer.IoBufferAllocator;
import com.treasuredata.partition.mpc.filter.InputFilter;
import com.treasuredata.partition.mpc.filter.ReadableByteChannelFilterSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class FilteredReadableByteChannel
implements ReadableByteChannel {
    protected ReadableByteChannel in;
    private InputFilter filter;
    private ReadableByteChannelFilterSource source;
    private Buffer buffer;

    public FilteredReadableByteChannel(ReadableByteChannel readableByteChannel, InputFilter inputFilter, IoBufferAllocator ioBufferAllocator) {
        this.in = readableByteChannel;
        this.filter = inputFilter;
        this.source = new ReadableByteChannelFilterSource(readableByteChannel, ioBufferAllocator);
        inputFilter.setSource(this.source);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.buffer == null) {
            this.buffer = this.source.next();
            if (this.buffer == null) {
                return -1;
            }
        }
        ByteBuffer byteBuffer2 = this.buffer.getByteBuffer();
        int n = BufferUtil.transferByteBuffer(byteBuffer2, byteBuffer);
        if (!byteBuffer2.hasRemaining()) {
            this.buffer.release();
            this.buffer = null;
        }
        return n;
    }

    @Override
    public boolean isOpen() {
        return this.in.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.filter.close();
    }
}

