/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.buffer;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.buffer.BufferAllocator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public class LeakCheckBufferAllocator
implements BufferAllocator {
    private BufferAllocator parentAllocator;
    private Set<LeakCheckBuffer> set;
    private long allocatedSize;
    private long peakSize;

    public LeakCheckBufferAllocator(BufferAllocator bufferAllocator) {
        this.parentAllocator = bufferAllocator;
        this.set = new HashSet<LeakCheckBuffer>();
    }

    @Override
    public synchronized Buffer allocate(int n) {
        String string = LeakCheckBufferAllocator.getStackTrace(n);
        LeakCheckBuffer leakCheckBuffer = new LeakCheckBuffer(this.parentAllocator.allocate(n), string);
        this.set.add(leakCheckBuffer);
        n = leakCheckBuffer.size();
        this.allocatedSize += (long)n;
        if (this.peakSize < this.allocatedSize) {
            this.peakSize = this.allocatedSize;
        }
        return leakCheckBuffer;
    }

    private synchronized void release(LeakCheckBuffer leakCheckBuffer) {
        int n = leakCheckBuffer.size();
        leakCheckBuffer.buffer.release();
        if (this.set.remove(leakCheckBuffer)) {
            this.allocatedSize -= (long)n;
        } else {
            System.out.println("detected double free: " + leakCheckBuffer.stackTrace);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        System.out.println("" + this.peakSize + " bytes allocated at peak and " + this.allocatedSize + " bytes leaked");
        this.parentAllocator.close();
        for (LeakCheckBuffer leakCheckBuffer : this.set) {
            System.out.println("detected memory leak: " + leakCheckBuffer.stackTrace);
        }
    }

    private static String getStackTrace(int n) {
        try {
            throw new Exception("" + n + " bytes");
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.toString();
        }
    }

    private class LeakCheckBuffer
    implements Buffer {
        private Buffer buffer;
        private String stackTrace;

        public LeakCheckBuffer(Buffer buffer, String string) {
            this.buffer = buffer;
            this.stackTrace = string;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return this.buffer.getByteBuffer();
        }

        @Override
        public void release() {
            LeakCheckBufferAllocator.this.release(this);
        }

        public int size() {
            return this.buffer.getByteBuffer().capacity();
        }

        public int hashCode() {
            return this.stackTrace.hashCode();
        }

        public boolean equals(Object object) {
            return this == object;
        }
    }
}

