/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.buffer;

import com.treasuredata.partition.mpc.buffer.AdaptiveIoBufferAllocator;
import com.treasuredata.partition.mpc.buffer.BufferAllocator;
import com.treasuredata.partition.mpc.buffer.CachedBufferAllocator;
import com.treasuredata.partition.mpc.buffer.FileBufferAllocator;
import com.treasuredata.partition.mpc.buffer.FixedIoBufferAllocator;
import com.treasuredata.partition.mpc.buffer.IoBufferAllocator;
import com.treasuredata.partition.mpc.buffer.MemoryBufferAllocator;
import java.io.File;
import java.io.IOException;

public class BufferAllocators {
    private BufferAllocators() {
    }

    public static IoBufferAllocator newAllocator() {
        MemoryBufferAllocator memoryBufferAllocator = new MemoryBufferAllocator();
        CachedBufferAllocator cachedBufferAllocator = new CachedBufferAllocator(memoryBufferAllocator, 0x4000000L);
        return new AdaptiveIoBufferAllocator(cachedBufferAllocator, 0x2000000L, 8192, 512);
    }

    public static IoBufferAllocator newMemoryCachedFixedIoBufferAllocator(long l, int n) {
        MemoryBufferAllocator memoryBufferAllocator = new MemoryBufferAllocator();
        CachedBufferAllocator cachedBufferAllocator = new CachedBufferAllocator(memoryBufferAllocator, l);
        return new FixedIoBufferAllocator(cachedBufferAllocator, n);
    }

    public static IoBufferAllocator newMemoryCachedAdaptiveIoBufferAllocator(long l, long l2, int n, int n2) {
        MemoryBufferAllocator memoryBufferAllocator = new MemoryBufferAllocator();
        CachedBufferAllocator cachedBufferAllocator = new CachedBufferAllocator(memoryBufferAllocator, l);
        return new AdaptiveIoBufferAllocator(cachedBufferAllocator, l2, n, n2);
    }

    public static BufferAllocator newFileCachedBufferAllocator(File[] fileArray, String string, String string2, long l) throws IOException {
        FileBufferAllocator fileBufferAllocator = new FileBufferAllocator(fileArray, string, string2);
        CachedBufferAllocator cachedBufferAllocator = new CachedBufferAllocator(fileBufferAllocator, l);
        return cachedBufferAllocator;
    }
}

