/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.provider;

import com.treasuredata.partition.io.IOProvider;
import com.treasuredata.partition.io.IORequestFilter;
import com.treasuredata.partition.io.auth.AwsAuthentication;
import com.treasuredata.partition.io.auth.AwsV4Authentication;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AwsProvider
implements IOProvider {
    private final URI endpoint;
    private final List<IORequestFilter> filters;

    public AwsProvider(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public AwsProvider(String string, String string2, String string3, boolean bl) {
        this.endpoint = URI.create(String.format("%s://%s", bl ? "https" : "http", string));
        Optional<String> optional = AwsProvider.getRegion(string, "s3");
        this.filters = optional.isPresent() ? ImmutableList.of(new AwsV4Authentication(string, optional.get(), "s3", string2, string3)) : ImmutableList.of(new AwsAuthentication(string2, string3));
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public List<IORequestFilter> getFilters() {
        return this.filters;
    }

    private static Optional<String> getRegion(String string, String string2) {
        Objects.requireNonNull(string, "endpoint is null");
        Preconditions.checkArgument("s3".equals(string2), "Service must be s3 but %s", (Object)string2);
        switch (string) {
            case "s3.amazonaws.com": 
            case "s3-external-1.amazonaws.com": {
                return Optional.of("us-east-1");
            }
            case "s3.us-east-2.amazonaws.com": 
            case "s3-us-east-2.amazonaws.com": {
                return Optional.of("us-east-2");
            }
            case "s3-us-west-1.amazonaws.com": {
                return Optional.of("us-west-1");
            }
            case "s3-us-west-2.amazonaws.com": {
                return Optional.of("us-west-2");
            }
            case "s3.ap-south-1.amazonaws.com": 
            case "s3-ap-south-1.amazonaws.com": {
                return Optional.of("ap-south-1");
            }
            case "s3.ap-northeast-2.amazonaws.com": 
            case "s3-ap-northeast-2.amazonaws.com": {
                return Optional.of("ap-northeast-2");
            }
            case "s3-ap-southeast-1.amazonaws.com": {
                return Optional.of("ap-southeast-1");
            }
            case "s3-ap-southeast-2.amazonaws.com": {
                return Optional.of("ap-southeast-2");
            }
            case "s3-ap-northeast-1.amazonaws.com": {
                return Optional.of("ap-northeast-1");
            }
            case "s3.eu-central-1.amazonaws.com": 
            case "s3-eu-central-1.amazonaws.com": {
                return Optional.of("eu-central-1");
            }
            case "s3-eu-west-1.amazonaws.com": {
                return Optional.of("eu-west-1");
            }
            case "s3-sa-east-1.amazonaws.com": {
                return Optional.of("sa-east-1");
            }
        }
        return Optional.empty();
    }
}

