/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.impl.jetty;

import com.treasuredata.partition.io.buffer.IOBufferPool;
import com.treasuredata.partition.io.impl.jetty.ManagedHttpConnection;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Promise;

public class ManagedClientTransport
extends HttpClientTransportOverHTTP {
    private final IOBufferPool bufferPool;
    private final long socketBufferSize;

    public ManagedClientTransport(IOBufferPool iOBufferPool, long l) {
        this(iOBufferPool, Runtime.getRuntime().availableProcessors(), l);
    }

    public ManagedClientTransport(IOBufferPool iOBufferPool, int n, long l) {
        super(n);
        this.bufferPool = iOBufferPool;
        this.socketBufferSize = l;
    }

    @Override
    protected void configure(HttpClient httpClient, SocketChannel socketChannel) throws IOException {
        super.configure(httpClient, socketChannel);
        socketChannel.socket().setReceiveBufferSize((int)this.socketBufferSize);
    }

    @Override
    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination httpDestination, Promise<Connection> promise) {
        return new ManagedHttpConnection(endPoint, httpDestination, promise, this.bufferPool);
    }
}

