/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.impl.jetty;

import com.treasuredata.partition.io.impl.jetty.ReflectionUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;

public class FileChannelEndPoint {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final ByteChannel channel;
    private final ChannelEndPoint endPoint;

    public FileChannelEndPoint(EndPoint endPoint) {
        if (endPoint instanceof ChannelEndPoint) {
            this.channel = (ByteChannel)ReflectionUtils.getPrivateField(ChannelEndPoint.class, endPoint, "_channel");
            this.endPoint = (ChannelEndPoint)endPoint;
        } else {
            this.channel = null;
            this.endPoint = null;
        }
    }

    public boolean enabled() {
        return this.channel != null;
    }

    public int fill(FileChannel fileChannel) throws IOException {
        if (this.endPoint.isInputShutdown()) {
            return -1;
        }
        try {
            long l = fileChannel.position();
            long l2 = fileChannel.transferFrom(this.channel, l, Integer.MAX_VALUE);
            if (l2 > 0L) {
                fileChannel.position(l + l2);
                this.endPoint.notIdle();
            } else if (l2 == -1L) {
                this.shutdownInput();
            }
            return (int)l2;
        }
        catch (IOException iOException) {
            this.shutdownInput();
            return -1;
        }
    }

    private void shutdownInput() {
        try {
            this.endPoint.fill(EMPTY_BUFFER);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

