/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.buffer;

import com.treasuredata.partition.io.buffer.IOBufferListener;
import com.treasuredata.partition.io.buffer.IOBufferPool;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import java.nio.ByteBuffer;

public class IOBuffer {
    private final IOBufferPool pool;
    private final IOBufferListener listener;
    private final ByteBuffer buffer;

    public IOBuffer(IOBufferPool iOBufferPool, IOBufferListener iOBufferListener, ByteBuffer byteBuffer) {
        this.pool = iOBufferPool;
        this.listener = iOBufferListener;
        this.buffer = Preconditions.checkNotNull(byteBuffer, "buffer is null");
    }

    public void release() {
        this.pool.release(this);
    }

    public final ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public final IOBufferListener getListener() {
        return this.listener;
    }

    public final boolean isFull() {
        return this.buffer.position() == this.pool.getBufferSize();
    }

    public final IOBuffer position(int n) {
        this.buffer.position(n);
        return this;
    }

    public final int position() {
        return this.buffer.position();
    }

    public final int remaining() {
        return this.buffer.remaining();
    }

    public final IOBuffer clear() {
        this.buffer.clear();
        return this;
    }

    public final IOBuffer slice() {
        return new IOBuffer(this.pool, this.listener, this.buffer.slice());
    }

    public final boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public static IOBuffer wrap(ByteBuffer byteBuffer) {
        return new NonManagedIOBuffer(byteBuffer);
    }

    public static class NonManagedIOBuffer
    extends IOBuffer {
        public NonManagedIOBuffer(ByteBuffer byteBuffer) {
            super(null, new IOBufferListener(){}, byteBuffer);
        }

        @Override
        public void release() {
        }
    }
}

