/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.buffer;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

public class FastBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final ConcurrentLinkedQueue<E> queue = new ConcurrentLinkedQueue();
    private final AtomicInteger count = new AtomicInteger(0);
    private final int capacity;
    private final ReentrantLock takeLock;
    private final Condition notEmpty;

    public FastBlockingQueue(int n) {
        this.capacity = n;
        this.takeLock = new ReentrantLock();
        this.notEmpty = this.takeLock.newCondition();
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public int size() {
        return this.count.get();
    }

    @Override
    public void put(E e) throws InterruptedException {
        while (!this.offer(e)) {
            LockSupport.park();
        }
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.queue.offer(e);
    }

    @Override
    public E take() throws InterruptedException {
        E e = this.poll();
        if (e != null) {
            return e;
        }
        this.takeLock.lockInterruptibly();
        try {
            while (true) {
                if ((e = this.poll()) != null) {
                    E e2 = e;
                    return e2;
                }
                this.notEmpty.await();
            }
        }
        finally {
            this.takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        E e = this.poll();
        if (e != null) {
            return e;
        }
        this.takeLock.lockInterruptibly();
        try {
            this.notEmpty.await(l, timeUnit);
            E e2 = this.poll();
            return e2;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.size();
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        E e;
        int n = 0;
        while ((e = this.poll()) != null) {
            collection.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        E e;
        int n2 = 0;
        while (n > 0 && (e = this.poll()) != null) {
            collection.add(e);
            ++n2;
            --n;
        }
        return n2;
    }

    @Override
    public boolean offer(E e) {
        if (this.count.incrementAndGet() > this.capacity) {
            this.count.decrementAndGet();
            return false;
        }
        this.queue.offer(e);
        this.notEmpty();
        return true;
    }

    @Override
    public E poll() {
        E e = this.queue.poll();
        if (e != null) {
            this.count.decrementAndGet();
        }
        return e;
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    private void notEmpty() {
        this.takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            this.takeLock.unlock();
        }
    }
}

