/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io;

import com.treasuredata.partition.io.IOGroup;
import com.treasuredata.partition.io.IOHandler;
import com.treasuredata.partition.io.IOPriority;
import com.treasuredata.partition.io.IORequestFilter;
import com.treasuredata.partition.io.IOServiceType;
import com.treasuredata.partition.io.RangeFilter;
import com.treasuredata.partition.io.RetryContext;
import com.treasuredata.partition.io.buffer.IOBufferListener;
import com.treasuredata.spark.thirdparty.com.google.common.base.MoreObjects;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.base.Throwables;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ArrayListMultimap;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableListMultimap;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableMap;
import com.treasuredata.spark.thirdparty.com.google.common.collect.Iterables;
import com.treasuredata.spark.thirdparty.com.google.common.collect.LinkedListMultimap;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ListMultimap;
import com.treasuredata.spark.thirdparty.com.google.common.collect.Multimap;
import com.treasuredata.spark.thirdparty.com.google.common.net.HostAndPort;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class IORequest
implements IOBufferListener {
    private static final Logger log = Logger.getLogger(IORequest.class.getName());
    public static final String ATTRIBUTE_THIS = "_IO_REQUEST_";
    private final IOGroup group;
    private final long offset;
    private final long size;
    private final URI uri;
    private final String method;
    private final IOPriority priority;
    private final IOHandler handler;
    private final RetryContext retryContext;
    private final ListMultimap<String, String> headers;
    private final Map<String, Object> attributes;
    private final List<IORequestFilter> filters;
    private final Path filePath;
    private final long fileSize;
    private final AtomicReference state;
    private final AtomicInteger bufferAllocated;
    private final AtomicReference<FileChannel> fileChannel = new AtomicReference();
    private final AtomicReference<IORequest> filteredRequest = new AtomicReference();

    private IORequest(IOGroup iOGroup, IOPriority iOPriority, long l, long l2, URI uRI, String string, IOHandler iOHandler, RetryContext retryContext, Path path, long l3, Multimap<String, String> multimap, Map<String, Object> map, List<IORequestFilter> list) {
        this.group = iOGroup;
        this.priority = iOPriority;
        this.offset = l;
        this.size = l2;
        this.uri = uRI;
        this.method = string;
        this.handler = iOHandler;
        this.retryContext = retryContext;
        this.headers = ImmutableListMultimap.copyOf(multimap);
        this.filters = ImmutableList.copyOf(list);
        this.state = new AtomicReference<State>(State.PENDING);
        this.bufferAllocated = new AtomicInteger();
        this.filePath = path;
        this.fileSize = l3;
        this.attributes = this.setThis(map);
    }

    public IORequest(IORequest iORequest, RetryContext retryContext) {
        this(iORequest, retryContext, new AtomicInteger(), iORequest.getHeaders());
    }

    private IORequest(IORequest iORequest, RetryContext retryContext, AtomicInteger atomicInteger, Multimap<String, String> multimap) {
        this.group = iORequest.group;
        this.priority = iORequest.priority;
        this.offset = iORequest.offset;
        this.size = iORequest.size;
        this.uri = iORequest.uri;
        this.method = iORequest.method;
        this.handler = iORequest.handler;
        this.retryContext = retryContext;
        this.filters = iORequest.filters;
        this.state = new AtomicReference<State>(State.PENDING);
        this.bufferAllocated = atomicInteger;
        this.filePath = iORequest.filePath;
        this.fileSize = iORequest.fileSize;
        this.headers = ImmutableListMultimap.copyOf(multimap);
        this.attributes = ImmutableMap.copyOf(iORequest.attributes);
    }

    private Map<String, Object> setThis(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        hashMap.put(ATTRIBUTE_THIS, this);
        return ImmutableMap.copyOf(hashMap);
    }

    public IOGroup getGroup() {
        return this.group;
    }

    public IOPriority getPriority() {
        return this.priority;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public URI getUri() {
        return this.uri;
    }

    public FileChannel getFileChannel() throws IOException {
        if (this.filePath == null) {
            return null;
        }
        if (this.fileChannel.get() == null && this.state.get() != State.COMPLETED) {
            this.fileChannel.set(FileChannel.open(this.filePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND));
        }
        return this.fileChannel.get();
    }

    public void closeFileChannel() {
        FileChannel fileChannel = this.fileChannel.getAndSet(null);
        if (fileChannel != null && fileChannel.isOpen()) {
            try {
                fileChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UriBuilder uriBuilder() {
        return new UriBuilder();
    }

    public String getMethod() {
        return this.method;
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public IOHandler getHandler() {
        return this.handler;
    }

    public IORequest applyFilters() {
        IORequest iORequest = this;
        for (IORequestFilter iORequestFilter : this.filters) {
            iORequest = iORequestFilter.filter(iORequest);
        }
        this.filteredRequest.set(iORequest);
        return iORequest;
    }

    public String getHeader(String string) {
        return Iterables.getOnlyElement(this.headers.get((Object)string.toLowerCase(Locale.ENGLISH)), null);
    }

    public List<String> getHeaders(String string) {
        return this.headers.get((Object)string.toLowerCase(Locale.ENGLISH));
    }

    public IORequest addHeader(String string, String string2) {
        ArrayListMultimap<String, String> arrayListMultimap = ArrayListMultimap.create();
        arrayListMultimap.putAll(this.headers);
        arrayListMultimap.put(string.toLowerCase(Locale.ENGLISH), string2);
        return new IORequest(this, this.retryContext, this.bufferAllocated, arrayListMultimap);
    }

    public RetryContext getRetryContext() {
        return this.retryContext;
    }

    @Override
    public void bufferAllocated() {
        this.bufferAllocated.incrementAndGet();
        this.group.bufferAllocated();
    }

    @Override
    public void bufferReleased() {
        if (this.bufferAllocated.decrementAndGet() < 0) {
            log.severe("Buffer released multiple times");
        }
        this.group.bufferReleased();
    }

    public int getQueuedBufferCount() {
        return this.bufferAllocated.get();
    }

    public void complete() {
        if (this.state.compareAndSet(State.RUNNING, State.COMPLETED)) {
            this.closeFileChannel();
            this.group.complete(this);
        }
    }

    public boolean completed() {
        return this.state.get() == State.COMPLETED;
    }

    IORequest start() {
        Preconditions.checkState(this.state.getAndSet(State.RUNNING) != State.RUNNING, "IORequest is already started");
        this.group.start(this);
        return this;
    }

    boolean started() {
        return this.state.get() != State.PENDING;
    }

    public boolean hasMore() {
        return this.filters.stream().anyMatch(iORequestFilter -> iORequestFilter.hasMore());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("group", this.group.getId()).add("uri", this.uri.toString()).add("state", this.state.toString()).add("buffer", this.bufferAllocated.get()).add("handler-fin", this.handler.isFinished()).toString();
    }

    public static class UriBuilder {
        private String scheme;
        private String host;
        private int port = -1;
        private String path = "";
        private final ListMultimap<String, String> params = LinkedListMultimap.create();

        public UriBuilder fromUri(URI uRI) {
            this.scheme = uRI.getScheme();
            this.host = uRI.getHost();
            this.port = uRI.getPort();
            this.path = uRI.getPath();
            return this;
        }

        public UriBuilder schema(String string) {
            this.scheme = string;
            return this;
        }

        public UriBuilder host(String string) {
            this.host = string;
            return this;
        }

        public UriBuilder port(int n) {
            this.port = n;
            return this;
        }

        public UriBuilder hostAndPort(String string) {
            return this.hostAndPort(HostAndPort.fromString(string));
        }

        public UriBuilder hostAndPort(HostAndPort hostAndPort) {
            this.host = hostAndPort.getHost();
            if (hostAndPort.hasPort()) {
                this.port = hostAndPort.getPort();
            }
            return this;
        }

        public UriBuilder path(String string) {
            Preconditions.checkNotNull(string, "path is null");
            StringBuilder stringBuilder = new StringBuilder(this.path);
            if (!this.path.endsWith("/")) {
                stringBuilder.append('/');
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            stringBuilder.append(string);
            this.path = stringBuilder.toString();
            return this;
        }

        public URI build() {
            Preconditions.checkState(this.scheme != null, "scheme has not been set");
            Preconditions.checkState(this.host != null, "host has not been set");
            try {
                return new URI(this.scheme, null, this.host, this.port, this.path, this.toQueryString(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw Throwables.propagate(uRISyntaxException);
            }
        }

        private String toQueryString() {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                if (!this.params.isEmpty()) {
                    stringBuilder.append('?');
                    Iterator iterator = this.params.entries().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        stringBuilder.append(URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8.name()));
                        if (entry.getValue() != null) {
                            stringBuilder.append('=');
                            stringBuilder.append(URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8.name()));
                        }
                        if (!iterator.hasNext()) continue;
                        stringBuilder.append('&');
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw Throwables.propagate(unsupportedEncodingException);
            }
            return stringBuilder.toString();
        }
    }

    public static class Builder {
        private IOServiceType serviceType;
        private IOGroup group;
        private long offset;
        private long size = -1L;
        private URI uri;
        private String method = "GET";
        private IOPriority priority = IOPriority.NORMAL;
        private IOHandler handler;
        private RetryContext retryContext = new RetryContext();
        private Path filePath;
        private long fileSize = -1L;
        private final ListMultimap<String, String> headers = ArrayListMultimap.create();
        private final HashMap<String, Object> attributes = new HashMap();
        private final ArrayList<IORequestFilter> filters = new ArrayList();

        public Builder about(IOServiceType iOServiceType) {
            this.serviceType = iOServiceType;
            return this;
        }

        public Builder http() {
            return this.about(IOServiceType.HTTP);
        }

        public Builder httpGet() {
            this.method("GET");
            return this.about(IOServiceType.HTTP);
        }

        public Builder httpPost() {
            this.method("POST");
            return this.about(IOServiceType.HTTP);
        }

        public Builder group(IOGroup iOGroup) {
            this.group = iOGroup;
            return this;
        }

        public Builder offset(long l) {
            this.offset = l;
            return this;
        }

        public Builder size(long l) {
            this.size = l;
            return this;
        }

        public Builder uri(URI uRI) {
            this.uri = uRI;
            return this;
        }

        public Builder method(String string) {
            this.method = string;
            return this;
        }

        public Builder priority(IOPriority iOPriority) {
            this.priority = iOPriority;
            return this;
        }

        public Builder handler(IOHandler iOHandler) {
            this.handler = iOHandler;
            return this;
        }

        public Builder filePath(Path path) {
            this.filePath = path;
            return this;
        }

        public Builder filePath(File file) {
            this.filePath = file.toPath();
            return this;
        }

        public Builder fileSize(long l) {
            this.fileSize = l;
            return this;
        }

        public Builder retry(RetryContext retryContext) {
            this.retryContext = new RetryContext(retryContext);
            return this;
        }

        public Builder header(String string, String string2) {
            this.headers.removeAll(string.toLowerCase(Locale.ENGLISH));
            this.headers.put(string.toLowerCase(Locale.ENGLISH), string2);
            return this;
        }

        public Builder addHeader(String string, String string2) {
            this.headers.put(string.toLowerCase(Locale.ENGLISH), string2);
            return this;
        }

        public Builder filter(IORequestFilter iORequestFilter) {
            this.filters.add(iORequestFilter);
            return this;
        }

        public Builder filter(List<IORequestFilter> list) {
            this.filters.addAll(list);
            return this;
        }

        public IORequest build() {
            Preconditions.checkState(this.serviceType != null, "serviceType has not been set");
            Preconditions.checkState(this.group != null, "group has not been set");
            Preconditions.checkState(this.handler != null, "handler has not been set");
            Preconditions.checkState(this.size != 0L, "size cannot be zero");
            Preconditions.checkState(this.fileSize > 0L ^ this.filePath == null, "filePath and fileSize must be set together");
            if (this.serviceType == IOServiceType.HTTP) {
                Preconditions.checkState(this.method != null, "method has not been set");
                this.filters.add(new RangeFilter(this.size));
            }
            return new IORequest(this.group, this.priority, this.offset, this.size, this.uri, this.method, this.handler, this.retryContext, this.filePath, this.fileSize, this.headers, this.attributes, this.filters);
        }
    }

    private static enum State {
        PENDING,
        RUNNING,
        COMPLETED;

    }
}

