/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io;

import com.treasuredata.partition.io.IOConfig;
import com.treasuredata.partition.io.IOGroup;
import com.treasuredata.partition.io.IOHandler;
import com.treasuredata.partition.io.IOPriority;
import com.treasuredata.partition.io.IORequest;
import com.treasuredata.partition.io.IOServiceType;
import com.treasuredata.partition.io.RetryContext;
import com.treasuredata.partition.io.buffer.IOBufferPool;
import com.treasuredata.spark.thirdparty.com.google.common.annotations.VisibleForTesting;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.collect.Iterators;
import com.treasuredata.spark.thirdparty.com.google.common.collect.PeekingIterator;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class IOManager {
    private static final Logger log = Logger.getLogger(IOManager.class.getName());
    private final String name;
    private final IOConfig config;
    private final IOBufferPool bufferPool;
    private final AtomicLong availableDownload;
    private final PriorityBlockingQueue<GroupRequest> groupRequests = new PriorityBlockingQueue(4096);
    private final PriorityBlockingQueue<RetryRequest> retryRequests = new PriorityBlockingQueue(1024);
    private final ConcurrentLinkedQueue<BlockedRequest> blockedRequests = new ConcurrentLinkedQueue();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ScheduledExecutorService retryExecutor = Executors.newSingleThreadScheduledExecutor();
    private final ScheduledExecutorService blockedExecutor = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentHashMap<String, IOGroup> groups = new ConcurrentHashMap();

    public IOManager(String string, IOConfig iOConfig) {
        this.name = string;
        this.config = Preconditions.checkNotNull(iOConfig);
        this.bufferPool = new IOBufferPool(iOConfig.getBufferSize(), iOConfig.getBufferPoolSize());
        this.availableDownload = new AtomicLong(iOConfig.getSystemDownloadSize());
    }

    public void start() {
        this.executor.execute(this::handleRequests);
        this.retryExecutor.scheduleAtFixedRate(this::handleRetryRequests, 0L, 100L, TimeUnit.MILLISECONDS);
        this.blockedExecutor.scheduleAtFixedRate(this::handleBlockedRequests, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    protected IOConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public IOServiceType getServiceType() {
        return this.config.getServiceType();
    }

    @VisibleForTesting
    long getAvailableDownload() {
        return this.availableDownload.get();
    }

    public IOGroup enterGroup(Optional<String> optional, int n) {
        String string2 = optional.orElseGet(() -> UUID.randomUUID().toString());
        IOGroup iOGroup2 = this.groups.compute(string2, (string, iOGroup) -> {
            if (iOGroup == null) {
                iOGroup = new IOGroup((String)string, this.config, this.availableDownload, n);
            }
            iOGroup.enter();
            return iOGroup;
        });
        return iOGroup2;
    }

    public IOBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public void leaveGroup(IOGroup iOGroup2) {
        if (iOGroup2.leave()) {
            this.groups.compute(iOGroup2.getId(), (string, iOGroup) -> {
                if (iOGroup != null && iOGroup.getSharedCount() == 0) {
                    return null;
                }
                return iOGroup;
            });
        }
    }

    public void enqueueRequest(IORequest iORequest) {
        this.enqueueRequest(Iterators.singletonIterator(iORequest));
    }

    public void enqueueRequest(Iterator<IORequest> iterator) {
        if (iterator.hasNext()) {
            this.groupRequests.add(new GroupRequest(iterator));
        }
    }

    public void completeRequest(IORequest iORequest2, Optional<Throwable> optional) {
        boolean bl = iORequest2.hasMore();
        IOHandler iOHandler = iORequest2.getHandler();
        Optional<Object> optional2 = Optional.empty();
        try {
            if (optional.isPresent()) {
                optional2 = this.fail(iORequest2, optional.get());
            } else if (!bl) {
                iOHandler.succeed(iORequest2);
            }
        }
        catch (Throwable throwable) {
            log.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
        if (optional.isPresent() || !bl) {
            iOHandler.completed(iORequest2);
        }
        if (optional.isPresent()) {
            optional2.flatMap(retryContext -> iOHandler.retry(iORequest2, retryContext.retry())).map(iORequest -> this.retryRequests.add(new RetryRequest((IORequest)iORequest)));
        } else if (bl) {
            this.enqueueRequest(iORequest2);
        }
    }

    private Optional<RetryContext> fail(IORequest iORequest, Throwable throwable) {
        Optional<RetryContext> optional = Optional.empty();
        IOHandler iOHandler = iORequest.getHandler();
        try {
            if (this.needRetry(iORequest, throwable)) {
                log.fine(throwable.toString());
                RetryContext retryContext = iORequest.getRetryContext().skippable(this.getMaxRetry(iORequest, throwable), this.isRequestSkippable(iORequest, throwable));
                if (retryContext.isLimitExceeds()) {
                    if (retryContext.isSkippable()) {
                        iOHandler.skip(iORequest);
                    } else {
                        iOHandler.exceedsRetryLimit(iORequest);
                    }
                } else {
                    optional = Optional.of(retryContext.slowDown(this.isSlowDown(iORequest, throwable)));
                }
            } else {
                iOHandler.fail(iORequest, throwable);
            }
        }
        catch (Throwable throwable2) {
            log.log(Level.SEVERE, throwable2.getMessage(), throwable2);
        }
        return optional;
    }

    protected abstract boolean isRequestSkippable(IORequest var1, Throwable var2);

    protected abstract int getMaxRetry(IORequest var1, Throwable var2);

    protected abstract boolean isSlowDown(IORequest var1, Throwable var2);

    protected abstract boolean needRetry(IORequest var1, Throwable var2);

    private void handleRequests() {
        Thread.currentThread().setName("io-manager");
        int n = this.config.getMaxConnectionsPerServer() * 2;
        ArrayList<GroupRequest> arrayList = new ArrayList<GroupRequest>();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                GroupRequest groupRequest;
                int n2 = n - this.getActiveRequestCount();
                while (n2 > 0 && (groupRequest = this.groupRequests.poll(arrayList.isEmpty() ? 1L : 0L, TimeUnit.SECONDS)) != null) {
                    if (groupRequest.isFinished()) continue;
                    if (groupRequest.needStart()) {
                        Iterator<IORequest> iterator = groupRequest.poll();
                        while (iterator.hasNext()) {
                            this.startRequest(iterator.next().start());
                            --n2;
                        }
                        if (groupRequest.isFinished()) continue;
                        arrayList.add(groupRequest);
                        continue;
                    }
                    this.blockedRequests.add(new BlockedRequest(groupRequest));
                }
                this.groupRequests.addAll(arrayList);
                arrayList.clear();
                if (n2 != 0 || this.groupRequests.isEmpty()) continue;
                LockSupport.parkNanos(10000000L);
            }
            catch (Throwable throwable) {
                log.log(Level.SEVERE, throwable.toString(), throwable);
            }
        }
    }

    private void handleRetryRequests() {
        long l = System.currentTimeMillis();
        Thread.currentThread().setName("io-manager-retry-" + l);
        try {
            RetryRequest retryRequest;
            while ((retryRequest = this.retryRequests.poll()) != null) {
                if (retryRequest.getBackOff() < l) {
                    this.enqueueRequest(retryRequest.getRequest());
                    continue;
                }
                this.retryRequests.add(retryRequest);
                break;
            }
        }
        catch (Throwable throwable) {
            log.log(Level.SEVERE, throwable.toString(), throwable);
        }
    }

    private void handleBlockedRequests() {
        long l = System.currentTimeMillis();
        Thread.currentThread().setName("io-manager-blocked-" + l);
        try {
            BlockedRequest blockedRequest;
            while ((blockedRequest = this.blockedRequests.peek()) != null && l - blockedRequest.getUpdateTime() >= 100L) {
                this.groupRequests.add(blockedRequest.getRequest());
                this.blockedRequests.poll();
            }
        }
        catch (Throwable throwable) {
            log.log(Level.SEVERE, throwable.toString(), throwable);
        }
    }

    public long getRetryRequestCount() {
        return this.retryRequests.size();
    }

    public long getBlockedRequestCount() {
        return this.blockedRequests.size();
    }

    public long getGroupRequestCount() {
        return this.groupRequests.size();
    }

    @VisibleForTesting
    boolean validate(IOConfig iOConfig) {
        try {
            this.assertEquals(this.groups.size(), 0, "groups has entry", new String[0]);
            this.assertEquals(this.groupRequests.size(), 0, "groupRequests has entry", new String[0]);
            this.assertEquals(this.availableDownload.get(), iOConfig.getSystemDownloadSize(), "availableDownload != config.getSystemDownloadSize()", new String[0]);
        }
        catch (AssertionError assertionError) {
            log.warning(((Throwable)((Object)assertionError)).getMessage());
            return false;
        }
        return true;
    }

    private void assertEquals(Object object, Object object2, String string, String ... stringArray) {
        if (!object.equals(object2)) {
            String string2 = String.format(string, stringArray);
            throw new AssertionError((Object)String.format("%s != %s : %s", object, object2, string2));
        }
    }

    protected abstract void startRequest(IORequest var1);

    public abstract int getActiveRequestCount();

    private static class RetryRequest
    implements Comparable {
        private static final SecureRandom random = new SecureRandom();
        private final IORequest request;
        private final long backOff;

        public RetryRequest(IORequest iORequest) {
            this.request = iORequest;
            this.backOff = this.calculateBackOff(iORequest.getRetryContext());
        }

        private long calculateBackOff(RetryContext retryContext) {
            long l = System.currentTimeMillis() + (long)random.nextInt(100);
            long l2 = retryContext.isSlowDown() ? 2000L : 500L;
            return l + l2 * (long)(1 + (retryContext.getRetryCount() - 1) * retryContext.getRetryCount());
        }

        public int compareTo(Object object) {
            RetryRequest retryRequest = (RetryRequest)object;
            return Long.compare(this.backOff, retryRequest.backOff);
        }

        public long getBackOff() {
            return this.backOff;
        }

        public IORequest getRequest() {
            return this.request;
        }
    }

    private static class BlockedRequest {
        private final GroupRequest request;
        private final long updateTime;

        public BlockedRequest(GroupRequest groupRequest) {
            this.request = groupRequest;
            this.updateTime = System.currentTimeMillis();
        }

        public long getUpdateTime() {
            return this.updateTime;
        }

        public GroupRequest getRequest() {
            return this.request;
        }
    }

    private static class GroupRequest
    implements Comparable {
        private final IOGroup group;
        private final IOPriority priority;
        private final PeekingIterator<IORequest> requests;

        public GroupRequest(Iterator<IORequest> iterator) {
            this.requests = Iterators.peekingIterator(iterator);
            this.priority = this.requests.peek().getPriority();
            this.group = this.requests.peek().getGroup();
        }

        public boolean needStart() {
            if (!this.requests.hasNext()) {
                return false;
            }
            return this.group.needStart(this.requests.peek());
        }

        public Iterator<IORequest> poll() {
            if (this.priority == IOPriority.HIGH) {
                return this.requests;
            }
            return Iterators.limit(this.requests, 1);
        }

        public boolean isFinished() {
            if (!this.requests.hasNext()) {
                return true;
            }
            return this.requests.peek().getHandler().isFinished();
        }

        public int compareTo(Object object) {
            GroupRequest groupRequest = (GroupRequest)object;
            int n = Integer.compare(this.priority.ordinal(), groupRequest.priority.ordinal());
            if (n == 0) {
                n = Long.compare(this.group.getUpdateTime(), groupRequest.group.getUpdateTime());
            }
            return n;
        }
    }
}

