/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.treasuredata.client.model.StringToNumberSerializer;
import com.treasuredata.client.model.TDUser;
import com.treasuredata.spark.thirdparty.com.google.common.base.MoreObjects;
import com.treasuredata.spark.thirdparty.com.google.common.base.Optional;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.collect.Lists;
import com.treasuredata.spark.thirdparty.com.google.common.primitives.Booleans;
import java.util.ArrayList;

final class ImmutableTDUser
extends TDUser {
    private final String id;
    private final String name;
    private final Optional<String> firstName;
    private final Optional<String> lastName;
    private final String email;
    private final Optional<String> phone;
    private final String gravatarUrl;
    private final boolean isAdministrator;
    private final String createdAt;
    private final String updatedAt;
    private final boolean isAccountOwner;

    private ImmutableTDUser(String id, String name, Optional<String> firstName, Optional<String> lastName, String email, Optional<String> phone, String gravatarUrl, boolean isAdministrator, String createdAt, String updatedAt, boolean isAccountOwner) {
        this.id = id;
        this.name = name;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.phone = phone;
        this.gravatarUrl = gravatarUrl;
        this.isAdministrator = isAdministrator;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.isAccountOwner = isAccountOwner;
    }

    @Override
    @JsonSerialize(using=StringToNumberSerializer.class)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="first_name")
    public Optional<String> getFirstName() {
        return this.firstName;
    }

    @Override
    @JsonProperty(value="last_name")
    public Optional<String> getLastName() {
        return this.lastName;
    }

    @Override
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @Override
    @JsonProperty(value="phone")
    public Optional<String> getPhone() {
        return this.phone;
    }

    @Override
    @JsonProperty(value="gravatar_url")
    public String getGravatarUrl() {
        return this.gravatarUrl;
    }

    @Override
    @JsonProperty(value="administrator")
    public boolean isAdministrator() {
        return this.isAdministrator;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updated_at")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="account_owner")
    public boolean isAccountOwner() {
        return this.isAccountOwner;
    }

    public final ImmutableTDUser withId(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(id, "id");
        return new ImmutableTDUser(newValue, this.name, this.firstName, this.lastName, this.email, this.phone, this.gravatarUrl, this.isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(name, "name");
        return new ImmutableTDUser(this.id, newValue, this.firstName, this.lastName, this.email, this.phone, this.gravatarUrl, this.isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withFirstName(String value) {
        Optional<String> newValue = Optional.of(value);
        if (this.firstName.equals(newValue)) {
            return this;
        }
        return new ImmutableTDUser(this.id, this.name, newValue, this.lastName, this.email, this.phone, this.gravatarUrl, this.isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withFirstName(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "firstName");
        if (this.firstName.equals(value)) {
            return this;
        }
        return new ImmutableTDUser(this.id, this.name, value, this.lastName, this.email, this.phone, this.gravatarUrl, this.isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withLastName(String value) {
        Optional<String> newValue = Optional.of(value);
        if (this.lastName.equals(newValue)) {
            return this;
        }
        return new ImmutableTDUser(this.id, this.name, this.firstName, newValue, this.email, this.phone, this.gravatarUrl, this.isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withLastName(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "lastName");
        if (this.lastName.equals(value)) {
            return this;
        }
        return new ImmutableTDUser(this.id, this.name, this.firstName, value, this.email, this.phone, this.gravatarUrl, this.isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withEmail(String email) {
        if (this.email.equals(email)) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(email, "email");
        return new ImmutableTDUser(this.id, this.name, this.firstName, this.lastName, newValue, this.phone, this.gravatarUrl, this.isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withPhone(String value) {
        Optional<String> newValue = Optional.of(value);
        if (this.phone.equals(newValue)) {
            return this;
        }
        return new ImmutableTDUser(this.id, this.name, this.firstName, this.lastName, this.email, newValue, this.gravatarUrl, this.isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withPhone(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "phone");
        if (this.phone.equals(value)) {
            return this;
        }
        return new ImmutableTDUser(this.id, this.name, this.firstName, this.lastName, this.email, value, this.gravatarUrl, this.isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withGravatarUrl(String gravatarUrl) {
        if (this.gravatarUrl.equals(gravatarUrl)) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(gravatarUrl, "gravatarUrl");
        return new ImmutableTDUser(this.id, this.name, this.firstName, this.lastName, this.email, this.phone, newValue, this.isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withIsAdministrator(boolean isAdministrator) {
        if (this.isAdministrator == isAdministrator) {
            return this;
        }
        return new ImmutableTDUser(this.id, this.name, this.firstName, this.lastName, this.email, this.phone, this.gravatarUrl, isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withCreatedAt(String createdAt) {
        if (this.createdAt.equals(createdAt)) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(createdAt, "createdAt");
        return new ImmutableTDUser(this.id, this.name, this.firstName, this.lastName, this.email, this.phone, this.gravatarUrl, this.isAdministrator, newValue, this.updatedAt, this.isAccountOwner);
    }

    public final ImmutableTDUser withUpdatedAt(String updatedAt) {
        if (this.updatedAt.equals(updatedAt)) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(updatedAt, "updatedAt");
        return new ImmutableTDUser(this.id, this.name, this.firstName, this.lastName, this.email, this.phone, this.gravatarUrl, this.isAdministrator, this.createdAt, newValue, this.isAccountOwner);
    }

    public final ImmutableTDUser withIsAccountOwner(boolean isAccountOwner) {
        if (this.isAccountOwner == isAccountOwner) {
            return this;
        }
        return new ImmutableTDUser(this.id, this.name, this.firstName, this.lastName, this.email, this.phone, this.gravatarUrl, this.isAdministrator, this.createdAt, this.updatedAt, isAccountOwner);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTDUser && this.equalTo((ImmutableTDUser)another);
    }

    private boolean equalTo(ImmutableTDUser another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.firstName.equals(another.firstName) && this.lastName.equals(another.lastName) && this.email.equals(another.email) && this.phone.equals(another.phone) && this.gravatarUrl.equals(another.gravatarUrl) && this.isAdministrator == another.isAdministrator && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.isAccountOwner == another.isAccountOwner;
    }

    public int hashCode() {
        int h2 = 31;
        h2 = h2 * 17 + this.id.hashCode();
        h2 = h2 * 17 + this.name.hashCode();
        h2 = h2 * 17 + this.firstName.hashCode();
        h2 = h2 * 17 + this.lastName.hashCode();
        h2 = h2 * 17 + this.email.hashCode();
        h2 = h2 * 17 + this.phone.hashCode();
        h2 = h2 * 17 + this.gravatarUrl.hashCode();
        h2 = h2 * 17 + Booleans.hashCode(this.isAdministrator);
        h2 = h2 * 17 + this.createdAt.hashCode();
        h2 = h2 * 17 + this.updatedAt.hashCode();
        h2 = h2 * 17 + Booleans.hashCode(this.isAccountOwner);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TDUser").omitNullValues().add("id", this.id).add("name", this.name).add("firstName", this.firstName.orNull()).add("lastName", this.lastName.orNull()).add("email", this.email).add("phone", this.phone.orNull()).add("gravatarUrl", this.gravatarUrl).add("isAdministrator", this.isAdministrator).add("createdAt", this.createdAt).add("updatedAt", this.updatedAt).add("isAccountOwner", this.isAccountOwner).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTDUser fromJson(Json json) {
        Builder builder = ImmutableTDUser.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.firstName != null) {
            builder.firstName(json.firstName);
        }
        if (json.lastName != null) {
            builder.lastName(json.lastName);
        }
        if (json.email != null) {
            builder.email(json.email);
        }
        if (json.phone != null) {
            builder.phone(json.phone);
        }
        if (json.gravatarUrl != null) {
            builder.gravatarUrl(json.gravatarUrl);
        }
        if (json.isAdministratorIsSet) {
            builder.isAdministrator(json.isAdministrator);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.isAccountOwnerIsSet) {
            builder.isAccountOwner(json.isAccountOwner);
        }
        return builder.build();
    }

    public static ImmutableTDUser copyOf(TDUser instance) {
        if (instance instanceof ImmutableTDUser) {
            return (ImmutableTDUser)instance;
        }
        return ImmutableTDUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements TDUser.Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_EMAIL = 4L;
        private static final long INIT_BIT_GRAVATAR_URL = 8L;
        private static final long INIT_BIT_IS_ADMINISTRATOR = 16L;
        private static final long INIT_BIT_CREATED_AT = 32L;
        private static final long INIT_BIT_UPDATED_AT = 64L;
        private static final long INIT_BIT_IS_ACCOUNT_OWNER = 128L;
        private long initBits = 255L;
        private String id;
        private String name;
        private Optional<String> firstName = Optional.absent();
        private Optional<String> lastName = Optional.absent();
        private String email;
        private Optional<String> phone = Optional.absent();
        private String gravatarUrl;
        private boolean isAdministrator;
        private String createdAt;
        private String updatedAt;
        private boolean isAccountOwner;

        private Builder() {
        }

        public final Builder from(TDUser instance) {
            Optional<String> lastNameOptional;
            Preconditions.checkNotNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            Optional<String> firstNameOptional = instance.getFirstName();
            if (firstNameOptional.isPresent()) {
                this.firstName(firstNameOptional);
            }
            if ((lastNameOptional = instance.getLastName()).isPresent()) {
                this.lastName(lastNameOptional);
            }
            this.email(instance.getEmail());
            Optional<String> phoneOptional = instance.getPhone();
            if (phoneOptional.isPresent()) {
                this.phone(phoneOptional);
            }
            this.gravatarUrl(instance.getGravatarUrl());
            this.isAdministrator(instance.isAdministrator());
            this.createdAt(instance.getCreatedAt());
            this.updatedAt(instance.getUpdatedAt());
            this.isAccountOwner(instance.isAccountOwner());
            return this;
        }

        @Override
        public final Builder id(String id) {
            this.id = Preconditions.checkNotNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = Optional.of(firstName);
            return this;
        }

        public final Builder firstName(Optional<String> firstName) {
            this.firstName = Preconditions.checkNotNull(firstName, "firstName");
            return this;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = Optional.of(lastName);
            return this;
        }

        public final Builder lastName(Optional<String> lastName) {
            this.lastName = Preconditions.checkNotNull(lastName, "lastName");
            return this;
        }

        @Override
        public final Builder email(String email) {
            this.email = Preconditions.checkNotNull(email, "email");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public final Builder phone(String phone) {
            this.phone = Optional.of(phone);
            return this;
        }

        public final Builder phone(Optional<String> phone) {
            this.phone = Preconditions.checkNotNull(phone, "phone");
            return this;
        }

        @Override
        public final Builder gravatarUrl(String gravatarUrl) {
            this.gravatarUrl = Preconditions.checkNotNull(gravatarUrl, "gravatarUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        public final Builder isAdministrator(boolean isAdministrator) {
            this.isAdministrator = isAdministrator;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = Preconditions.checkNotNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = Preconditions.checkNotNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @Override
        public final Builder isAccountOwner(boolean isAccountOwner) {
            this.isAccountOwner = isAccountOwner;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @Override
        public ImmutableTDUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTDUser(this.id, this.name, this.firstName, this.lastName, this.email, this.phone, this.gravatarUrl, this.isAdministrator, this.createdAt, this.updatedAt, this.isAccountOwner);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("email");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("gravatarUrl");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("isAdministrator");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("isAccountOwner");
            }
            return "Cannot build TDUser, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends TDUser {
        String id;
        String name;
        Optional<String> firstName = Optional.absent();
        Optional<String> lastName = Optional.absent();
        String email;
        Optional<String> phone = Optional.absent();
        String gravatarUrl;
        boolean isAdministrator;
        boolean isAdministratorIsSet;
        String createdAt;
        String updatedAt;
        boolean isAccountOwner;
        boolean isAccountOwnerIsSet;

        Json() {
        }

        @JsonSerialize(using=StringToNumberSerializer.class)
        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="first_name")
        public void setFirstName(Optional<String> firstName) {
            this.firstName = firstName;
        }

        @JsonProperty(value="last_name")
        public void setLastName(Optional<String> lastName) {
            this.lastName = lastName;
        }

        @JsonProperty(value="email")
        public void setEmail(String email) {
            this.email = email;
        }

        @JsonProperty(value="phone")
        public void setPhone(Optional<String> phone) {
            this.phone = phone;
        }

        @JsonProperty(value="gravatar_url")
        public void setGravatarUrl(String gravatarUrl) {
            this.gravatarUrl = gravatarUrl;
        }

        @JsonProperty(value="administrator")
        public void setIsAdministrator(boolean isAdministrator) {
            this.isAdministrator = isAdministrator;
            this.isAdministratorIsSet = true;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="account_owner")
        public void setIsAccountOwner(boolean isAccountOwner) {
            this.isAccountOwner = isAccountOwner;
            this.isAccountOwnerIsSet = true;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getFirstName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLastName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEmail() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPhone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGravatarUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAdministrator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAccountOwner() {
            throw new UnsupportedOperationException();
        }
    }
}

