/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.impl;

import com.treasuredata.client.ProxyConfig;
import com.treasuredata.client.TDClientException;
import com.treasuredata.client.TDClientHttpException;
import com.treasuredata.spark.thirdparty.com.google.common.base.Optional;
import com.treasuredata.spark.thirdparty.okhttp3.Authenticator;
import com.treasuredata.spark.thirdparty.okhttp3.Credentials;
import com.treasuredata.spark.thirdparty.okhttp3.Request;
import com.treasuredata.spark.thirdparty.okhttp3.Response;
import com.treasuredata.spark.thirdparty.okhttp3.Route;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyAuthenticator
implements Authenticator {
    private final Logger logger = LoggerFactory.getLogger(ProxyAuthenticator.class);
    private final ProxyConfig proxyConfig;
    private Optional<String> proxyAuthCache = Optional.absent();

    public ProxyAuthenticator(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Override
    public Request authenticate(Route route, Response response) throws IOException {
        if (response.request().header("Proxy-Authorization") != null) {
            throw new IOException(new TDClientHttpException(TDClientException.ErrorType.PROXY_AUTHENTICATION_FAILURE, "Proxy authentication failure", 407, null));
        }
        if (!this.proxyAuthCache.isPresent()) {
            this.logger.debug("Proxy authorization requested for " + route.address());
            this.proxyAuthCache = Optional.of(Credentials.basic(this.proxyConfig.getUser().or(""), this.proxyConfig.getPassword().or("")));
        }
        return response.request().newBuilder().addHeader("Proxy-Authorization", this.proxyAuthCache.get()).build();
    }
}

