# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/05-pipeline.ipynb (unless otherwise specified).

__all__ = ['download_source_data', 'construct_intermediate_dataset', 'update_dataset_updates', 'clean_output_dataset',
           'save_output_dataset', 'generate_output_dataset_pipeline']

# Cell
from powerdict import download, construct, update

import os
from typing import Any

from dagster import execute_pipeline, pipeline, solid, Field

# Cell
@solid()
def download_source_data(_, raw_data_dir: str):
    download.download_opsd_power_plants_data(raw_data_dir)

    return

@solid()
def construct_intermediate_dataset(_, definitions_dir: str, raw_data_dir: str, intermediate_data_dir: str) -> Any:
    df = construct.construct_output_df(definitions_dir, raw_data_dir)
    df.to_csv(f'{intermediate_data_dir}/power_stations.csv')

    return df

@solid()
def update_dataset_updates(_, df: Any, updates_data_dir: str) -> Any:
    df = update.apply_updates(df, updates_data_dir)

    return df

@solid()
def clean_output_dataset(_, df: Any, definitions_dir: str) -> Any:
    df = update.check_and_apply_output_defs(df, definitions_dir)

    return df

@solid()
def save_output_dataset(_, df: Any, output_data_dir: str):
    if not os.path.exists(output_data_dir):
        os.makedirs(output_data_dir)

    df.to_csv(f'{output_data_dir}/power_stations.csv')

    return

# Cell
@pipeline
def generate_output_dataset_pipeline():
    download_source_data()

    df = construct_intermediate_dataset()
    df = update_dataset_updates(df)
    df = clean_output_dataset(df)

    save_output_dataset(df)