<p align="center">
    <img src="https://raw.githubusercontent.com/danielfrg/jupyter-flex/main/docs/assets/img/logo.png" width="450px">
</p>

<p align="center">
    <a href="https://pypi.org/project/jupyter-flex/">
        <img src="https://img.shields.io/pypi/v/jupyter-flex.svg">
    </a>
    <a href="https://pypi.org/project/mkdocs-jupyter">
        <img src="https://img.shields.io/pypi/pyversions/jupyter-flex.svg">
    </a>
    <a href="https://github.com/danielfrg/jupyter-flex/actions/workflows/test.yml">
        <img src="https://github.com/danielfrg/jupyter-flex/workflows/test/badge.svg">
    </a>
    <a href="https://github.com/danielfrg/jupyter-flex/actions/workflows/docs.yml">
        <img src="https://github.com/danielfrg/jupyter-flex/workflows/docs/badge.svg">
    </a>
    <a href="https://codecov.io/gh/danielfrg/jupyter-flex?branch=main">
        <img src="https://codecov.io/gh/danielfrg/jupyter-flex/branch/main/graph/badge.svg">
    </a>
    <a href="https://github.com/danielfrg/jupyter-flex/blob/main/LICENSE.txt">
        <img src="https://img.shields.io/:license-Apache%202-blue.svg">
    </a>
    <a href="https://mybinder.org/v2/gh/danielfrg/jupyter-flex/main?urlpath=voila%2Ftree%2Fexamples">
        <img src="https://mybinder.org/badge_logo.svg">
    </a>
</p>

<p align="center">
  <a href="https://jupyter-flex.danielfrg.com">Documentation</a>
  ·
  <a href="#installation">Installation</a>
</p>

# Build dashboards using Jupyter Notebooks

- Use Markdown headers and Jupyter Notebook cell tags to define the dashboard layout and its components
- Flexible and easy way to specify row and column based layouts
- Use [nbconvert](https://nbconvert.readthedocs.io/en/latest/) to create static reports
- Use [Voila](https://github.com/voila-dashboards/voila) to start a live Jupyter Kernel for fully dynamic applications
- Support for [Jupyter widgets](https://ipywidgets.readthedocs.io/en/latest/)

<a href="https://mybinder.org/v2/gh/danielfrg/jupyter-flex/main?urlpath=%2Fvoila%2Frender%2Fexamples%2Fmovie-explorer.ipynb"><img src="https://jupyter-flex.danielfrg.com/assets/img/screenshots/jupyter_flex.tests.test_examples/apps_movie-explorer-reference.png" alt="Jupyter-flex: Movie Explorer"  width=270></a>
<a href="https://jupyter-flex.danielfrg.com/examples/nba-scoring.html"><img src="https://jupyter-flex.danielfrg.com/assets/img/screenshots/jupyter_flex.tests.test_examples/apps_nba-scoring-reference.png" alt="Jupyter-flex: NBA Scoring" width=270></a>
<a href="https://jupyter-flex.danielfrg.com/examples/altair.html"><img src="https://jupyter-flex.danielfrg.com/assets/img/screenshots/jupyter_flex.tests.test_examples/plots_altair-reference.png" alt="Jupyter-flex: Bokeh plots"  width=270></a>

## Installation

```shell
pip install jupyter-flex
```

## Documentation

Learn more in the [jupyter-flex documentation](https://jupyter-flex.danielfrg.com).

## Contributing

See [CONTRIBUTING.md](https://github.com/danielfrg/jupyter-flex/blob/main/CONTRIBUTING.md).
