"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractAsyncToJSON = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
/**
 * combines the potentially paginated response from async Textract calls and stores as one combines JSON.
 *
 * This construct is not memory optimzed (yet) and will combine all JSON by loading them to memory.
 * Large responses could exceed the memory potentially, the memory size is set to Lambda max.
 *
 * Reduce the memory size to your needs if your processing does not yield large responses to save Lamda cost.
 *
 *
 * Input: "textract_result"."TextractTempOutputJsonPath"
 * Output: "TextractOutputJsonPath"
 *
 * Example (Python)
 * ```python
    textract_async_to_json = tcdk.TextractAsyncToJSON(
        self,
        "TextractAsyncToJSON2",
        s3_output_prefix=s3_output_prefix,
        s3_output_bucket=s3_output_bucket)
  ```
 */
class TextractAsyncToJSON extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var lambdaLogLevel = props.lambdaLogLevel === undefined ? 'DEBUG' : props.lambdaLogLevel;
        var lambdaTimeout = props.lambdaTimeout === undefined ? 900 : props.lambdaTimeout;
        var lambdaMemoryMB = props.lambdaMemoryMB === undefined ? 10240 : props.lambdaMemoryMB;
        const asyncToJSONFunction = new lambda.DockerImageFunction(this, 'TextractAsyncToJSON', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/async_to_json/')),
            memorySize: lambdaMemoryMB,
            architecture: lambda.Architecture.X86_64,
            environment: {
                S3_OUTPUT_BUCKET: props.s3OutputBucket,
                S3_OUTPUT_PREFIX: props.s3OutputPrefix,
                LOG_LEVEL: lambdaLogLevel,
            },
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
        });
        asyncToJSONFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['s3:Get*', 's3:List*', 's3:Put*'],
            resources: ['*'],
        }));
        const asyncToJSON = new tasks.LambdaInvoke(this, id, {
            lambdaFunction: asyncToJSONFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(900),
            outputPath: '$.Payload',
        });
        this.startState = asyncToJSON;
        this.endStates = [asyncToJSON];
    }
}
exports.TextractAsyncToJSON = TextractAsyncToJSON;
_a = JSII_RTTI_SYMBOL_1;
TextractAsyncToJSON[_a] = { fqn: "amazon-textract-idp-cdk-constructs.TextractAsyncToJSON", version: "0.0.6" };
//# sourceMappingURL=data:application/json;base64,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