import { Construct } from 'constructs';
export interface TextractConfigurationProps {
    readonly configuration_table: string;
}
/**
 * CloudFormation Custom Resources importing default configuration values from default_config.csv
 * into DynamoDB table.
 * Used by the Configuration Construct to configure Textrat features.
 * The DynamoDB table can be configured to your requirements.
 * The configuration has to match the manifest format.
 * Essentially the Configuration construct looks up the classification
 * and if a match is found in the DynamoDB table, configures the context
 * manifest object to include the configuration.
 *
 */
export declare class TextractConfiguration extends Construct {
    private configurationInit;
    response: string;
    constructor(scope: Construct, id: string, props: TextractConfigurationProps);
}
