# DO NOT EDIT! This file is automatically generated
import typing

from commercetools.helpers import RemoveEmptyValuesMixin
from commercetools.platform.models.message import Message, MessagePagedQueryResponse
from commercetools.typing import OptionalListStr

from . import abstract, traits


class _MessageQuerySchema(
    traits.ExpandableSchema,
    traits.SortableSchema,
    traits.PagingSchema,
    traits.QuerySchema,
):
    pass


class MessageService(abstract.AbstractService):
    """A message represents a change or an action performed on a resource (like an
    Order or a Product)."""

    def get_by_id(self, id: str, *, expand: OptionalListStr = None) -> Message:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"messages/{id}", params=params, response_class=Message
        )

    def query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> MessagePagedQueryResponse:
        """A message represents a change or an action performed on a resource (like
        an Order or a Product).
        """
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _MessageQuerySchema,
        )
        return self._client._get(
            endpoint="messages", params=params, response_class=MessagePagedQueryResponse
        )
