"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketApi = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
const integration_1 = require("./integration");
const route_1 = require("./route");
/**
 * (experimental) Create a new API Gateway WebSocket API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Api
 */
class WebSocketApi extends base_1.ApiBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketApiProps(props);
        this.webSocketApiName = (_b = props === null || props === void 0 ? void 0 : props.apiName) !== null && _b !== void 0 ? _b : id;
        const resource = new aws_apigatewayv2_1.CfnApi(this, 'Resource', {
            name: this.webSocketApiName,
            protocolType: 'WEBSOCKET',
            description: props === null || props === void 0 ? void 0 : props.description,
            routeSelectionExpression: (_c = props === null || props === void 0 ? void 0 : props.routeSelectionExpression) !== null && _c !== void 0 ? _c : '$request.body.action',
        });
        this.apiId = resource.ref;
        this.apiEndpoint = resource.attrApiEndpoint;
        if (props === null || props === void 0 ? void 0 : props.connectRouteOptions) {
            this.addRoute('$connect', props.connectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.disconnectRouteOptions) {
            this.addRoute('$disconnect', props.disconnectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.defaultRouteOptions) {
            this.addRoute('$default', props.defaultRouteOptions);
        }
    }
    /**
     * @internal
     */
    _addIntegration(scope, config) {
        const { configHash, integration: existingIntegration } = this._integrationCache.getIntegration(scope, config);
        if (existingIntegration) {
            return existingIntegration;
        }
        const integration = new integration_1.WebSocketIntegration(scope, `WebSocketIntegration-${configHash}`, {
            webSocketApi: this,
            integrationType: config.type,
            integrationUri: config.uri,
        });
        this._integrationCache.saveIntegration(scope, config, integration);
        return integration;
    }
    /**
     * (experimental) Add a new route.
     *
     * @experimental
     */
    addRoute(routeKey, options) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteOptions(options);
        return new route_1.WebSocketRoute(this, `${routeKey}-Route`, {
            webSocketApi: this,
            routeKey,
            ...options,
        });
    }
    /**
     * (experimental) Grant access to the API Gateway management API for this WebSocket API to an IAM principal (Role/Group/User).
     *
     * @param identity The principal.
     * @experimental
     */
    grantManageConnections(identity) {
        const arn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'execute-api',
            resource: this.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/*/POST/@connections/*`],
        });
    }
}
exports.WebSocketApi = WebSocketApi;
_a = JSII_RTTI_SYMBOL_1;
WebSocketApi[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketApi", version: "2.0.0-alpha.11" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXBpLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLGlEQUF3RDtBQUN4RCw2Q0FBb0M7QUFFcEMsbUVBQXNEO0FBRXRELHlDQUF5QztBQUN6QywrQ0FBc0Y7QUFDdEYsbUNBQWdFOzs7Ozs7O0FBaUNoRSxNQUFhLFlBQWEsU0FBUSxjQUFPOzs7O0lBT3ZDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBeUI7O1FBQ2pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7O1FBRWpCLElBQUksQ0FBQyxnQkFBZ0IsU0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsT0FBTyxtQ0FBSSxFQUFFLENBQUM7UUFFN0MsTUFBTSxRQUFRLEdBQUcsSUFBSSx5QkFBTSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDNUMsSUFBSSxFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDM0IsWUFBWSxFQUFFLFdBQVc7WUFDekIsV0FBVyxFQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxXQUFXO1lBQy9CLHdCQUF3QixRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSx3QkFBd0IsbUNBQUksc0JBQXNCO1NBQ3BGLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxLQUFLLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztRQUMxQixJQUFJLENBQUMsV0FBVyxHQUFHLFFBQVEsQ0FBQyxlQUFlLENBQUM7UUFFNUMsSUFBSSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsbUJBQW1CLEVBQUU7WUFDOUIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxVQUFVLEVBQUUsS0FBSyxDQUFDLG1CQUFtQixDQUFDLENBQUM7U0FDdEQ7UUFDRCxJQUFJLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxzQkFBc0IsRUFBRTtZQUNqQyxJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWEsRUFBRSxLQUFLLENBQUMsc0JBQXNCLENBQUMsQ0FBQztTQUM1RDtRQUNELElBQUksS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLG1CQUFtQixFQUFFO1lBQzlCLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO1NBQ3REO0tBQ0Y7SUFFRDs7T0FFRztJQUNJLGVBQWUsQ0FBQyxLQUFnQixFQUFFLE1BQXVDO1FBQzlFLE1BQU0sRUFBRSxVQUFVLEVBQUUsV0FBVyxFQUFFLG1CQUFtQixFQUFFLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFDOUcsSUFBSSxtQkFBbUIsRUFBRTtZQUN2QixPQUFPLG1CQUEyQyxDQUFDO1NBQ3BEO1FBRUQsTUFBTSxXQUFXLEdBQUcsSUFBSSxrQ0FBb0IsQ0FBQyxLQUFLLEVBQUUsd0JBQXdCLFVBQVUsRUFBRSxFQUFFO1lBQ3hGLFlBQVksRUFBRSxJQUFJO1lBQ2xCLGVBQWUsRUFBRSxNQUFNLENBQUMsSUFBSTtZQUM1QixjQUFjLEVBQUUsTUFBTSxDQUFDLEdBQUc7U0FDM0IsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLFdBQVcsQ0FBQyxDQUFDO1FBRW5FLE9BQU8sV0FBVyxDQUFDO0tBQ3BCOzs7Ozs7SUFHTSxRQUFRLENBQUMsUUFBZ0IsRUFBRSxPQUE4Qjs7UUFDOUQsT0FBTyxJQUFJLHNCQUFjLENBQUMsSUFBSSxFQUFFLEdBQUcsUUFBUSxRQUFRLEVBQUU7WUFDbkQsWUFBWSxFQUFFLElBQUk7WUFDbEIsUUFBUTtZQUNSLEdBQUcsT0FBTztTQUNYLENBQUMsQ0FBQztLQUNKOzs7Ozs7O0lBR00sc0JBQXNCLENBQUMsUUFBb0I7UUFDaEQsTUFBTSxHQUFHLEdBQUcsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO1lBQ25DLE9BQU8sRUFBRSxhQUFhO1lBQ3RCLFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSztTQUNyQixDQUFDLENBQUM7UUFFSCxPQUFPLGVBQUssQ0FBQyxjQUFjLENBQUM7WUFDMUIsT0FBTyxFQUFFLFFBQVE7WUFDakIsT0FBTyxFQUFFLENBQUMsK0JBQStCLENBQUM7WUFDMUMsWUFBWSxFQUFFLENBQUMsR0FBRyxHQUFHLHdCQUF3QixDQUFDO1NBQy9DLENBQUMsQ0FBQztLQUNKOztBQXhFSCxvQ0F5RUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBHcmFudCwgSUdyYW50YWJsZSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgU3RhY2sgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmbkFwaSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1hcGlnYXRld2F5djInO1xuaW1wb3J0IHsgSUFwaSB9IGZyb20gJy4uL2NvbW1vbi9hcGknO1xuaW1wb3J0IHsgQXBpQmFzZSB9IGZyb20gJy4uL2NvbW1vbi9iYXNlJztcbmltcG9ydCB7IFdlYlNvY2tldFJvdXRlSW50ZWdyYXRpb25Db25maWcsIFdlYlNvY2tldEludGVncmF0aW9uIH0gZnJvbSAnLi9pbnRlZ3JhdGlvbic7XG5pbXBvcnQgeyBXZWJTb2NrZXRSb3V0ZSwgV2ViU29ja2V0Um91dGVPcHRpb25zIH0gZnJvbSAnLi9yb3V0ZSc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSVdlYlNvY2tldEFwaSBleHRlbmRzIElBcGkge1xuICAvKipcbiAgICogQWRkIGEgd2Vic29ja2V0IGludGVncmF0aW9uXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgX2FkZEludGVncmF0aW9uKHNjb3BlOiBDb25zdHJ1Y3QsIGNvbmZpZzogV2ViU29ja2V0Um91dGVJbnRlZ3JhdGlvbkNvbmZpZyk6IFdlYlNvY2tldEludGVncmF0aW9uXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgV2ViU29ja2V0QXBpUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFwaU5hbWU/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcm91dGVTZWxlY3Rpb25FeHByZXNzaW9uPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY29ubmVjdFJvdXRlT3B0aW9ucz86IFdlYlNvY2tldFJvdXRlT3B0aW9ucztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRpc2Nvbm5lY3RSb3V0ZU9wdGlvbnM/OiBXZWJTb2NrZXRSb3V0ZU9wdGlvbnM7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkZWZhdWx0Um91dGVPcHRpb25zPzogV2ViU29ja2V0Um91dGVPcHRpb25zO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFdlYlNvY2tldEFwaSBleHRlbmRzIEFwaUJhc2UgaW1wbGVtZW50cyBJV2ViU29ja2V0QXBpIHtcbiAgcHVibGljIHJlYWRvbmx5IGFwaUlkOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBhcGlFbmRwb2ludDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgd2ViU29ja2V0QXBpTmFtZT86IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wcz86IFdlYlNvY2tldEFwaVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMud2ViU29ja2V0QXBpTmFtZSA9IHByb3BzPy5hcGlOYW1lID8/IGlkO1xuXG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuQXBpKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIG5hbWU6IHRoaXMud2ViU29ja2V0QXBpTmFtZSxcbiAgICAgIHByb3RvY29sVHlwZTogJ1dFQlNPQ0tFVCcsXG4gICAgICBkZXNjcmlwdGlvbjogcHJvcHM/LmRlc2NyaXB0aW9uLFxuICAgICAgcm91dGVTZWxlY3Rpb25FeHByZXNzaW9uOiBwcm9wcz8ucm91dGVTZWxlY3Rpb25FeHByZXNzaW9uID8/ICckcmVxdWVzdC5ib2R5LmFjdGlvbicsXG4gICAgfSk7XG4gICAgdGhpcy5hcGlJZCA9IHJlc291cmNlLnJlZjtcbiAgICB0aGlzLmFwaUVuZHBvaW50ID0gcmVzb3VyY2UuYXR0ckFwaUVuZHBvaW50O1xuXG4gICAgaWYgKHByb3BzPy5jb25uZWN0Um91dGVPcHRpb25zKSB7XG4gICAgICB0aGlzLmFkZFJvdXRlKCckY29ubmVjdCcsIHByb3BzLmNvbm5lY3RSb3V0ZU9wdGlvbnMpO1xuICAgIH1cbiAgICBpZiAocHJvcHM/LmRpc2Nvbm5lY3RSb3V0ZU9wdGlvbnMpIHtcbiAgICAgIHRoaXMuYWRkUm91dGUoJyRkaXNjb25uZWN0JywgcHJvcHMuZGlzY29ubmVjdFJvdXRlT3B0aW9ucyk7XG4gICAgfVxuICAgIGlmIChwcm9wcz8uZGVmYXVsdFJvdXRlT3B0aW9ucykge1xuICAgICAgdGhpcy5hZGRSb3V0ZSgnJGRlZmF1bHQnLCBwcm9wcy5kZWZhdWx0Um91dGVPcHRpb25zKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgX2FkZEludGVncmF0aW9uKHNjb3BlOiBDb25zdHJ1Y3QsIGNvbmZpZzogV2ViU29ja2V0Um91dGVJbnRlZ3JhdGlvbkNvbmZpZyk6IFdlYlNvY2tldEludGVncmF0aW9uIHtcbiAgICBjb25zdCB7IGNvbmZpZ0hhc2gsIGludGVncmF0aW9uOiBleGlzdGluZ0ludGVncmF0aW9uIH0gPSB0aGlzLl9pbnRlZ3JhdGlvbkNhY2hlLmdldEludGVncmF0aW9uKHNjb3BlLCBjb25maWcpO1xuICAgIGlmIChleGlzdGluZ0ludGVncmF0aW9uKSB7XG4gICAgICByZXR1cm4gZXhpc3RpbmdJbnRlZ3JhdGlvbiBhcyBXZWJTb2NrZXRJbnRlZ3JhdGlvbjtcbiAgICB9XG5cbiAgICBjb25zdCBpbnRlZ3JhdGlvbiA9IG5ldyBXZWJTb2NrZXRJbnRlZ3JhdGlvbihzY29wZSwgYFdlYlNvY2tldEludGVncmF0aW9uLSR7Y29uZmlnSGFzaH1gLCB7XG4gICAgICB3ZWJTb2NrZXRBcGk6IHRoaXMsXG4gICAgICBpbnRlZ3JhdGlvblR5cGU6IGNvbmZpZy50eXBlLFxuICAgICAgaW50ZWdyYXRpb25Vcmk6IGNvbmZpZy51cmksXG4gICAgfSk7XG4gICAgdGhpcy5faW50ZWdyYXRpb25DYWNoZS5zYXZlSW50ZWdyYXRpb24oc2NvcGUsIGNvbmZpZywgaW50ZWdyYXRpb24pO1xuXG4gICAgcmV0dXJuIGludGVncmF0aW9uO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhZGRSb3V0ZShyb3V0ZUtleTogc3RyaW5nLCBvcHRpb25zOiBXZWJTb2NrZXRSb3V0ZU9wdGlvbnMpIHtcbiAgICByZXR1cm4gbmV3IFdlYlNvY2tldFJvdXRlKHRoaXMsIGAke3JvdXRlS2V5fS1Sb3V0ZWAsIHtcbiAgICAgIHdlYlNvY2tldEFwaTogdGhpcyxcbiAgICAgIHJvdXRlS2V5LFxuICAgICAgLi4ub3B0aW9ucyxcbiAgICB9KTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgZ3JhbnRNYW5hZ2VDb25uZWN0aW9ucyhpZGVudGl0eTogSUdyYW50YWJsZSk6IEdyYW50IHtcbiAgICBjb25zdCBhcm4gPSBTdGFjay5vZih0aGlzKS5mb3JtYXRBcm4oe1xuICAgICAgc2VydmljZTogJ2V4ZWN1dGUtYXBpJyxcbiAgICAgIHJlc291cmNlOiB0aGlzLmFwaUlkLFxuICAgIH0pO1xuXG4gICAgcmV0dXJuIEdyYW50LmFkZFRvUHJpbmNpcGFsKHtcbiAgICAgIGdyYW50ZWU6IGlkZW50aXR5LFxuICAgICAgYWN0aW9uczogWydleGVjdXRlLWFwaTpNYW5hZ2VDb25uZWN0aW9ucyddLFxuICAgICAgcmVzb3VyY2VBcm5zOiBbYCR7YXJufS8qL1BPU1QvQGNvbm5lY3Rpb25zLypgXSxcbiAgICB9KTtcbiAgfVxufVxuIl19