"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpStage = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
const DEFAULT_STAGE_NAME = '$default';
class HttpStageBase extends base_1.StageBase {
    /**
     * (experimental) Metric for the number of client-side errors captured in a given period.
     *
     * @experimental
     */
    metricClientError(props) {
        return this.metric('4xx', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the number of server-side errors captured in a given period.
     *
     * @experimental
     */
    metricServerError(props) {
        return this.metric('5xx', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the amount of data processed in bytes.
     *
     * @experimental
     */
    metricDataProcessed(props) {
        return this.metric('DataProcessed', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the total number API requests in a given period.
     *
     * @experimental
     */
    metricCount(props) {
        return this.metric('Count', { statistic: 'SampleCount', ...props });
    }
    /**
     * (experimental) Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     *
     * @experimental
     */
    metricIntegrationLatency(props) {
        return this.metric('IntegrationLatency', props);
    }
    /**
     * (experimental) The time between when API Gateway receives a request from a client and when it returns a response to the client.
     *
     * The latency includes the integration latency and other API Gateway overhead.
     *
     * @experimental
     */
    metricLatency(props) {
        return this.metric('Latency', props);
    }
}
/**
 * (experimental) Represents a stage where an instance of the API is deployed.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Stage
 */
class HttpStage extends HttpStageBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName ? props.stageName : DEFAULT_STAGE_NAME,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpStageProps(props);
        new aws_apigatewayv2_1.CfnStage(this, 'Resource', {
            apiId: props.httpApi.apiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
        });
        this.stageName = this.physicalName;
        this.baseApi = props.httpApi;
        this.api = props.httpApi;
        if (props.domainMapping) {
            this._addDomainMapping(props.domainMapping);
        }
    }
    /**
     * (experimental) Import an existing stage into this CDK app.
     *
     * @experimental
     */
    static fromHttpStageAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpStageAttributes(attrs);
        class Import extends HttpStageBase {
            constructor() {
                super(...arguments);
                this.baseApi = attrs.api;
                this.stageName = attrs.stageName;
                this.api = attrs.api;
            }
            get url() {
                throw new Error('url is not available for imported stages.');
            }
            get domainUrl() {
                throw new Error('domainUrl is not available for imported stages.');
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) The URL to this stage.
     *
     * @experimental
     */
    get url() {
        const s = aws_cdk_lib_1.Stack.of(this);
        const urlPath = this.stageName === DEFAULT_STAGE_NAME ? '' : this.stageName;
        return `https://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * (experimental) The custom domain URL to this stage.
     *
     * @experimental
     */
    get domainUrl() {
        var _b;
        if (!this._apiMapping) {
            throw new Error('domainUrl is not available when no API mapping is associated with the Stage');
        }
        return `https://${this._apiMapping.domainName.name}/${(_b = this._apiMapping.mappingKey) !== null && _b !== void 0 ? _b : ''}`;
    }
}
exports.HttpStage = HttpStage;
_a = JSII_RTTI_SYMBOL_1;
HttpStage[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpStage", version: "2.0.0-alpha.11" };
//# sourceMappingURL=data:application/json;base64,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