"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNoneAuthorizer = exports.HttpAuthorizer = exports.AuthorizerPayloadVersion = exports.HttpAuthorizerType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * (experimental) Supported Authorizer types.
 *
 * @experimental
 */
var HttpAuthorizerType;
(function (HttpAuthorizerType) {
    HttpAuthorizerType["JWT"] = "JWT";
    HttpAuthorizerType["LAMBDA"] = "REQUEST";
})(HttpAuthorizerType = exports.HttpAuthorizerType || (exports.HttpAuthorizerType = {}));
/**
 * (experimental) Payload format version for lambda authorizers.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html
 * @experimental
 */
var AuthorizerPayloadVersion;
(function (AuthorizerPayloadVersion) {
    AuthorizerPayloadVersion["VERSION_1_0"] = "1.0";
    AuthorizerPayloadVersion["VERSION_2_0"] = "2.0";
})(AuthorizerPayloadVersion = exports.AuthorizerPayloadVersion || (exports.AuthorizerPayloadVersion = {}));
/**
 * (experimental) An authorizer for Http Apis.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Authorizer
 */
class HttpAuthorizer extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpAuthorizerProps(props);
        let authorizerPayloadFormatVersion = props.payloadFormatVersion;
        if (props.type === HttpAuthorizerType.JWT && (!props.jwtAudience || props.jwtAudience.length === 0 || !props.jwtIssuer)) {
            throw new Error('jwtAudience and jwtIssuer are mandatory for JWT authorizers');
        }
        if (props.type === HttpAuthorizerType.LAMBDA && !props.authorizerUri) {
            throw new Error('authorizerUri is mandatory for Lambda authorizers');
        }
        /**
         * This check is required because Cloudformation will fail stack creation is this property
         * is set for the JWT authorizer. AuthorizerPayloadFormatVersion can only be set for REQUEST authorizer
         */
        if (props.type === HttpAuthorizerType.LAMBDA && typeof authorizerPayloadFormatVersion === 'undefined') {
            authorizerPayloadFormatVersion = AuthorizerPayloadVersion.VERSION_2_0;
        }
        const resource = new aws_apigatewayv2_1.CfnAuthorizer(this, 'Resource', {
            name: (_c = props.authorizerName) !== null && _c !== void 0 ? _c : id,
            apiId: props.httpApi.apiId,
            authorizerType: props.type,
            identitySource: props.identitySource,
            jwtConfiguration: undefinedIfNoKeys({
                audience: props.jwtAudience,
                issuer: props.jwtIssuer,
            }),
            enableSimpleResponses: props.enableSimpleResponses,
            authorizerPayloadFormatVersion,
            authorizerUri: props.authorizerUri,
            authorizerResultTtlInSeconds: (_d = props.resultsCacheTtl) === null || _d === void 0 ? void 0 : _d.toSeconds(),
        });
        this.authorizerId = resource.ref;
    }
    /**
     * (experimental) Import an existing HTTP Authorizer into this CDK app.
     *
     * @experimental
     */
    static fromHttpAuthorizerAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpAuthorizerAttributes(attrs);
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.authorizerId = attrs.authorizerId;
                this.authorizerType = attrs.authorizerType;
            }
            bind() {
                return {
                    authorizerId: attrs.authorizerId,
                    authorizationType: attrs.authorizerType,
                };
            }
        }
        return new Import(scope, id);
    }
}
exports.HttpAuthorizer = HttpAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpAuthorizer", version: "2.0.0-alpha.11" };
function undefinedIfNoKeys(obj) {
    const allUndefined = Object.values(obj).every(val => val === undefined);
    return allUndefined ? undefined : obj;
}
/**
 * (experimental) Explicitly configure no authorizers on specific HTTP API routes.
 *
 * @experimental
 */
class HttpNoneAuthorizer {
    /**
     * (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(_) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpRouteAuthorizerBindOptions(_);
        return {
            authorizationType: 'NONE',
        };
    }
}
exports.HttpNoneAuthorizer = HttpNoneAuthorizer;
_b = JSII_RTTI_SYMBOL_1;
HttpNoneAuthorizer[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpNoneAuthorizer", version: "2.0.0-alpha.11" };
//# sourceMappingURL=data:application/json;base64,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