"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApi = exports.CorsHttpMethod = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
const integration_1 = require("./integration");
const route_1 = require("./route");
const stage_1 = require("./stage");
const vpc_link_1 = require("./vpc-link");
/**
 * (experimental) Supported CORS HTTP methods.
 *
 * @experimental
 */
var CorsHttpMethod;
(function (CorsHttpMethod) {
    CorsHttpMethod["ANY"] = "*";
    CorsHttpMethod["DELETE"] = "DELETE";
    CorsHttpMethod["GET"] = "GET";
    CorsHttpMethod["HEAD"] = "HEAD";
    CorsHttpMethod["OPTIONS"] = "OPTIONS";
    CorsHttpMethod["PATCH"] = "PATCH";
    CorsHttpMethod["POST"] = "POST";
    CorsHttpMethod["PUT"] = "PUT";
})(CorsHttpMethod = exports.CorsHttpMethod || (exports.CorsHttpMethod = {}));
class HttpApiBase extends base_1.ApiBase {
    constructor() {
        super(...arguments);
        this.vpcLinks = {};
    }
    /**
     * (experimental) Metric for the number of client-side errors captured in a given period.
     *
     * @experimental
     */
    metricClientError(props) {
        return this.metric('4xx', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the number of server-side errors captured in a given period.
     *
     * @experimental
     */
    metricServerError(props) {
        return this.metric('5xx', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the amount of data processed in bytes.
     *
     * @experimental
     */
    metricDataProcessed(props) {
        return this.metric('DataProcessed', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the total number API requests in a given period.
     *
     * @experimental
     */
    metricCount(props) {
        return this.metric('Count', { statistic: 'SampleCount', ...props });
    }
    /**
     * (experimental) Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     *
     * @experimental
     */
    metricIntegrationLatency(props) {
        return this.metric('IntegrationLatency', props);
    }
    /**
     * (experimental) The time between when API Gateway receives a request from a client and when it returns a response to the client.
     *
     * The latency includes the integration latency and other API Gateway overhead.
     *
     * @experimental
     */
    metricLatency(props) {
        return this.metric('Latency', props);
    }
    /**
     * (experimental) Add a new VpcLink.
     *
     * @experimental
     */
    addVpcLink(options) {
        const { vpcId } = options.vpc;
        if (vpcId in this.vpcLinks) {
            return this.vpcLinks[vpcId];
        }
        const count = Object.keys(this.vpcLinks).length + 1;
        const vpcLink = new vpc_link_1.VpcLink(this, `VpcLink-${count}`, options);
        this.vpcLinks[vpcId] = vpcLink;
        return vpcLink;
    }
    /**
     * @internal
     */
    _addIntegration(scope, config) {
        const { configHash, integration: existingIntegration } = this._integrationCache.getIntegration(scope, config);
        if (existingIntegration) {
            return existingIntegration;
        }
        const integration = new integration_1.HttpIntegration(scope, `HttpIntegration-${configHash}`, {
            httpApi: this,
            integrationType: config.type,
            integrationUri: config.uri,
            method: config.method,
            connectionId: config.connectionId,
            connectionType: config.connectionType,
            payloadFormatVersion: config.payloadFormatVersion,
            secureServerName: config.secureServerName,
            parameterMapping: config.parameterMapping,
        });
        this._integrationCache.saveIntegration(scope, config, integration);
        return integration;
    }
}
/**
 * (experimental) Create a new API Gateway HTTP API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Api
 */
class HttpApi extends HttpApiBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpApiProps(props);
        this.httpApiName = (_b = props === null || props === void 0 ? void 0 : props.apiName) !== null && _b !== void 0 ? _b : id;
        this.disableExecuteApiEndpoint = props === null || props === void 0 ? void 0 : props.disableExecuteApiEndpoint;
        let corsConfiguration;
        if (props === null || props === void 0 ? void 0 : props.corsPreflight) {
            const cors = props.corsPreflight;
            if (cors.allowOrigins && cors.allowOrigins.includes('*') && cors.allowCredentials) {
                throw new Error("CORS preflight - allowCredentials is not supported when allowOrigin is '*'");
            }
            const { allowCredentials, allowHeaders, allowMethods, allowOrigins, exposeHeaders, maxAge, } = props.corsPreflight;
            corsConfiguration = {
                allowCredentials,
                allowHeaders,
                allowMethods,
                allowOrigins,
                exposeHeaders,
                maxAge: maxAge === null || maxAge === void 0 ? void 0 : maxAge.toSeconds(),
            };
        }
        const apiProps = {
            name: this.httpApiName,
            protocolType: 'HTTP',
            corsConfiguration,
            description: props === null || props === void 0 ? void 0 : props.description,
            disableExecuteApiEndpoint: this.disableExecuteApiEndpoint,
        };
        const resource = new aws_apigatewayv2_1.CfnApi(this, 'Resource', apiProps);
        this.apiId = resource.ref;
        this.httpApiId = resource.ref;
        this._apiEndpoint = resource.attrApiEndpoint;
        this.defaultAuthorizer = props === null || props === void 0 ? void 0 : props.defaultAuthorizer;
        this.defaultAuthorizationScopes = props === null || props === void 0 ? void 0 : props.defaultAuthorizationScopes;
        if (props === null || props === void 0 ? void 0 : props.defaultIntegration) {
            new route_1.HttpRoute(this, 'DefaultRoute', {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.DEFAULT,
                integration: props.defaultIntegration,
                authorizer: props.defaultAuthorizer,
                authorizationScopes: props.defaultAuthorizationScopes,
            });
        }
        if ((props === null || props === void 0 ? void 0 : props.createDefaultStage) === undefined || props.createDefaultStage === true) {
            this.defaultStage = new stage_1.HttpStage(this, 'DefaultStage', {
                httpApi: this,
                autoDeploy: true,
                domainMapping: props === null || props === void 0 ? void 0 : props.defaultDomainMapping,
            });
            // to ensure the domain is ready before creating the default stage
            if (props === null || props === void 0 ? void 0 : props.defaultDomainMapping) {
                this.defaultStage.node.addDependency(props.defaultDomainMapping.domainName);
            }
        }
        if ((props === null || props === void 0 ? void 0 : props.createDefaultStage) === false && props.defaultDomainMapping) {
            throw new Error('defaultDomainMapping not supported with createDefaultStage disabled');
        }
    }
    /**
     * (experimental) Import an existing HTTP API into this CDK app.
     *
     * @experimental
     */
    static fromHttpApiAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpApiAttributes(attrs);
        class Import extends HttpApiBase {
            constructor() {
                super(...arguments);
                this.apiId = attrs.httpApiId;
                this.httpApiId = attrs.httpApiId;
                this._apiEndpoint = attrs.apiEndpoint;
            }
            get apiEndpoint() {
                if (!this._apiEndpoint) {
                    throw new Error('apiEndpoint is not configured on the imported HttpApi.');
                }
                return this._apiEndpoint;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Get the default endpoint for this API.
     *
     * @experimental
     */
    get apiEndpoint() {
        if (this.disableExecuteApiEndpoint) {
            throw new Error('apiEndpoint is not accessible when disableExecuteApiEndpoint is set to true.');
        }
        return this._apiEndpoint;
    }
    /**
     * (experimental) Get the URL to the default stage of this API.
     *
     * Returns `undefined` if `createDefaultStage` is unset.
     *
     * @experimental
     */
    get url() {
        return this.defaultStage ? this.defaultStage.url : undefined;
    }
    /**
     * (experimental) Add a new stage.
     *
     * @experimental
     */
    addStage(id, options) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpStageOptions(options);
        const stage = new stage_1.HttpStage(this, id, {
            httpApi: this,
            ...options,
        });
        return stage;
    }
    /**
     * (experimental) Add multiple routes that uses the same configuration.
     *
     * The routes all go to the same path, but for different
     * methods.
     *
     * @experimental
     */
    addRoutes(options) {
        var _b;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_AddRoutesOptions(options);
        const methods = (_b = options.methods) !== null && _b !== void 0 ? _b : [route_1.HttpMethod.ANY];
        return methods.map((method) => {
            var _b, _c;
            const authorizationScopes = (_b = options.authorizationScopes) !== null && _b !== void 0 ? _b : this.defaultAuthorizationScopes;
            return new route_1.HttpRoute(this, `${method}${options.path}`, {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.with(options.path, method),
                integration: options.integration,
                authorizer: (_c = options.authorizer) !== null && _c !== void 0 ? _c : this.defaultAuthorizer,
                authorizationScopes,
            });
        });
    }
}
exports.HttpApi = HttpApi;
_a = JSII_RTTI_SYMBOL_1;
HttpApi[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpApi", version: "2.0.0-alpha.11" };
//# sourceMappingURL=data:application/json;base64,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