"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiMapping = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const api_1 = require("../http/api");
/**
 * (experimental) Create a new API mapping for API Gateway API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
class ApiMapping extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_ApiMappingProps(props);
        let stage = props.stage;
        if (!stage) {
            if (props.api instanceof api_1.HttpApi) {
                if (props.api.defaultStage) {
                    stage = props.api.defaultStage;
                }
                else {
                    throw new Error('stage is required if default stage is not available');
                }
            }
            else {
                throw new Error('stage is required for WebSocket API');
            }
        }
        if (props.apiMappingKey === '') {
            throw new Error('empty string for api mapping key not allowed');
        }
        const apiMappingProps = {
            apiId: props.api.apiId,
            domainName: props.domainName.name,
            stage: stage.stageName,
            apiMappingKey: props.apiMappingKey,
        };
        const resource = new aws_apigatewayv2_1.CfnApiMapping(this, 'Resource', apiMappingProps);
        // ensure the dependency on the provided stage
        this.node.addDependency(stage);
        this.apiMappingId = resource.ref;
        this.mappingKey = props.apiMappingKey;
        this.domainName = props.domainName;
    }
    /**
     * (experimental) import from API ID.
     *
     * @experimental
     */
    static fromApiMappingAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_ApiMappingAttributes(attrs);
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.apiMappingId = attrs.apiMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.ApiMapping = ApiMapping;
_a = JSII_RTTI_SYMBOL_1;
ApiMapping[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.ApiMapping", version: "2.0.0-alpha.11" };
//# sourceMappingURL=data:application/json;base64,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