"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import cosmos.base.v1beta1.coin_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Params(google.protobuf.message.Message):
    """Params defines the module parameters for the x/oracle module."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VOTE_PERIOD_FIELD_NUMBER: builtins.int
    VOTE_THRESHOLD_FIELD_NUMBER: builtins.int
    REWARD_BAND_FIELD_NUMBER: builtins.int
    WHITELIST_FIELD_NUMBER: builtins.int
    SLASH_FRACTION_FIELD_NUMBER: builtins.int
    SLASH_WINDOW_FIELD_NUMBER: builtins.int
    MIN_VALID_PER_WINDOW_FIELD_NUMBER: builtins.int
    TWAP_LOOKBACK_WINDOW_FIELD_NUMBER: builtins.int
    MIN_VOTERS_FIELD_NUMBER: builtins.int
    vote_period: builtins.int
    """VotePeriod defines the number of blocks during which voting takes place."""
    vote_threshold: builtins.str
    """VoteThreshold specifies the minimum proportion of votes that must be 
    received for a ballot to pass.
    """
    reward_band: builtins.str
    """RewardBand defines a maxium divergence that a price vote can have from the
    weighted median in the ballot. If a vote lies within the valid range
    defined by:
    	μ := weightedMedian,
    	validRange := μ ± (μ * rewardBand / 2),
    then rewards are added to the validator performance.
    Note that if the reward band is smaller than 1 standard
    deviation, the band is taken to be 1 standard deviation.a price
    """
    @property
    def whitelist(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The set of whitelisted markets, or asset pairs, for the module. 
        Ex. '["unibi:uusd","ubtc:uusd"]'
        """
    slash_fraction: builtins.str
    """SlashFraction returns the proportion of an oracle's stake that gets 
    slashed in the event of slashing. `SlashFraction` specifies the exact 
    penalty for failing a voting period.
    """
    slash_window: builtins.int
    """SlashWindow returns the number of voting periods that specify a 
    "slash window". After each slash window, all oracles that have missed more 
    than the penalty threshold are slashed. Missing the penalty threshold is 
    synonymous with submitting fewer valid votes than `MinValidPerWindow`.
    """
    min_valid_per_window: builtins.str
    @property
    def twap_lookback_window(self) -> google.protobuf.duration_pb2.Duration:
        """Amount of time to look back for TWAP calculations"""
    min_voters: builtins.int
    """The minimum number of voters (i.e. oracle validators) per pair for it to be considered a passing ballot.
    Recommended at least 4.
    """
    def __init__(
        self,
        *,
        vote_period: builtins.int = ...,
        vote_threshold: builtins.str = ...,
        reward_band: builtins.str = ...,
        whitelist: collections.abc.Iterable[builtins.str] | None = ...,
        slash_fraction: builtins.str = ...,
        slash_window: builtins.int = ...,
        min_valid_per_window: builtins.str = ...,
        twap_lookback_window: google.protobuf.duration_pb2.Duration | None = ...,
        min_voters: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["twap_lookback_window", b"twap_lookback_window"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["min_valid_per_window", b"min_valid_per_window", "min_voters", b"min_voters", "reward_band", b"reward_band", "slash_fraction", b"slash_fraction", "slash_window", b"slash_window", "twap_lookback_window", b"twap_lookback_window", "vote_period", b"vote_period", "vote_threshold", b"vote_threshold", "whitelist", b"whitelist"]) -> None: ...

global___Params = Params

@typing_extensions.final
class AggregateExchangeRatePrevote(google.protobuf.message.Message):
    """Struct for aggregate prevoting on the ExchangeRateVote.
    The purpose of aggregate prevote is to hide vote exchange rates with hash
    which is formatted as hex string in SHA256("{salt}:({pair},{exchange_rate})|...|({pair},{exchange_rate}):{voter}")
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HASH_FIELD_NUMBER: builtins.int
    VOTER_FIELD_NUMBER: builtins.int
    SUBMIT_BLOCK_FIELD_NUMBER: builtins.int
    hash: builtins.str
    voter: builtins.str
    submit_block: builtins.int
    def __init__(
        self,
        *,
        hash: builtins.str = ...,
        voter: builtins.str = ...,
        submit_block: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["hash", b"hash", "submit_block", b"submit_block", "voter", b"voter"]) -> None: ...

global___AggregateExchangeRatePrevote = AggregateExchangeRatePrevote

@typing_extensions.final
class AggregateExchangeRateVote(google.protobuf.message.Message):
    """MsgAggregateExchangeRateVote - struct for voting on
    the exchange rates different assets.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXCHANGE_RATE_TUPLES_FIELD_NUMBER: builtins.int
    VOTER_FIELD_NUMBER: builtins.int
    @property
    def exchange_rate_tuples(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ExchangeRateTuple]: ...
    voter: builtins.str
    def __init__(
        self,
        *,
        exchange_rate_tuples: collections.abc.Iterable[global___ExchangeRateTuple] | None = ...,
        voter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["exchange_rate_tuples", b"exchange_rate_tuples", "voter", b"voter"]) -> None: ...

global___AggregateExchangeRateVote = AggregateExchangeRateVote

@typing_extensions.final
class ExchangeRateTuple(google.protobuf.message.Message):
    """ExchangeRateTuple - struct to store interpreted exchange rates data to store"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAIR_FIELD_NUMBER: builtins.int
    EXCHANGE_RATE_FIELD_NUMBER: builtins.int
    pair: builtins.str
    exchange_rate: builtins.str
    def __init__(
        self,
        *,
        pair: builtins.str = ...,
        exchange_rate: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["exchange_rate", b"exchange_rate", "pair", b"pair"]) -> None: ...

global___ExchangeRateTuple = ExchangeRateTuple

@typing_extensions.final
class PairReward(google.protobuf.message.Message):
    """PairReward defines a credit object towards validators
    which provide prices faithfully for different pairs.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAIR_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    VOTE_PERIODS_FIELD_NUMBER: builtins.int
    COINS_FIELD_NUMBER: builtins.int
    pair: builtins.str
    """pair defines the pair for which we incentivize validator to provide prices for."""
    id: builtins.int
    """id uniquely identifies the rewards instance of the pair"""
    vote_periods: builtins.int
    """vote_periods defines the vote periods left in which rewards will be distributed."""
    @property
    def coins(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[cosmos.base.v1beta1.coin_pb2.Coin]:
        """Coins defines the amount of coins to distribute in a single vote period."""
    def __init__(
        self,
        *,
        pair: builtins.str = ...,
        id: builtins.int = ...,
        vote_periods: builtins.int = ...,
        coins: collections.abc.Iterable[cosmos.base.v1beta1.coin_pb2.Coin] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["coins", b"coins", "id", b"id", "pair", b"pair", "vote_periods", b"vote_periods"]) -> None: ...

global___PairReward = PairReward
