# Core-get

Client for the core-get package sharing system

This command-line client can be used to download and publish packages to [core-get.org](https://core-get.org)

## Roadmap

### Short-term goals
* Facilitate VHDL FPGA development
* Enable sharing of device-agnostic FPGA components
### Long-term goals
* Support for Verilog and SystemVerilog
* Enable mixed VHDL-version FPGA development
* Enable mixed HDL FPGA development
### Non-goals
* SystemC support
* MyHDL support
* Schematics support
* Perfect integration with all tools

## Nomenclature
* Component
* Configuration
* Device - A single FPGA chip (*not* a device family)
* Device family - A device family comprising several devices. Can vary in capabilities between devices.
* Entity
* Module
* Options
* Project - An FPGA project for one tool, configured for one device
* Package
* Settings
* Tool - A software tool provided by a vendor for synthesis of HDL designs, targeting one or more device families.
* Variant - Implementation of a package targeting one or more devices.
* Version - A specific version of a package.
* Vendor - An FPGA vendor (Altera, Intel, Lattice, Xilinx...)
