"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnService = exports.toJson_AtDefinition = exports.toJson_OutsideSupportHoursDefinition = exports.toJson_DuringSupportHoursDefinition = exports.toJson_SupportHoursDefinition = exports.toJson_ScheduledActionsDefinition = exports.toJson_IncidentUrgencyRuleDefinition = exports.toJson_CfnServiceProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnServiceProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnServiceProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AcknowledgementTimeout': obj.acknowledgementTimeout,
        'AlertCreation': obj.alertCreation,
        'AlertGrouping': obj.alertGrouping,
        'AlertGroupingTimeout': obj.alertGroupingTimeout,
        'AutoResolveTimeout': obj.autoResolveTimeout,
        'Description': obj.description,
        'EscalationPolicy': obj.escalationPolicy,
        'Name': obj.name,
        'IncidentUrgencyRule': obj.incidentUrgencyRule?.map(y => toJson_IncidentUrgencyRuleDefinition(y)),
        'ScheduledActions': obj.scheduledActions?.map(y => toJson_ScheduledActionsDefinition(y)),
        'SupportHours': obj.supportHours?.map(y => toJson_SupportHoursDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnServiceProps = toJson_CfnServiceProps;
/**
 * Converts an object of type 'IncidentUrgencyRuleDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_IncidentUrgencyRuleDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Type': obj.type,
        'Urgency': obj.urgency,
        'DuringSupportHours': obj.duringSupportHours?.map(y => toJson_DuringSupportHoursDefinition(y)),
        'OutsideSupportHours': obj.outsideSupportHours?.map(y => toJson_OutsideSupportHoursDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_IncidentUrgencyRuleDefinition = toJson_IncidentUrgencyRuleDefinition;
/**
 * Converts an object of type 'ScheduledActionsDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ScheduledActionsDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ToUrgency': obj.toUrgency,
        'Type': obj.type,
        'At': obj.at?.map(y => toJson_AtDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ScheduledActionsDefinition = toJson_ScheduledActionsDefinition;
/**
 * Converts an object of type 'SupportHoursDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_SupportHoursDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'DaysOfWeek': obj.daysOfWeek?.map(y => y),
        'EndTime': obj.endTime,
        'StartTime': obj.startTime,
        'TimeZone': obj.timeZone,
        'Type': obj.type,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_SupportHoursDefinition = toJson_SupportHoursDefinition;
/**
 * Converts an object of type 'DuringSupportHoursDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_DuringSupportHoursDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Type': obj.type,
        'Urgency': obj.urgency,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_DuringSupportHoursDefinition = toJson_DuringSupportHoursDefinition;
/**
 * Converts an object of type 'OutsideSupportHoursDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_OutsideSupportHoursDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Type': obj.type,
        'Urgency': obj.urgency,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_OutsideSupportHoursDefinition = toJson_OutsideSupportHoursDefinition;
/**
 * Converts an object of type 'AtDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AtDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Type': obj.type,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AtDefinition = toJson_AtDefinition;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `TF::PagerDuty::Service`
 *
 * @cloudformationResource TF::PagerDuty::Service
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnService extends cdk.CfnResource {
    /**
     * Create a new `TF::PagerDuty::Service`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnService.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnServiceProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrCreatedAt = cdk.Token.asString(this.getAtt('CreatedAt'));
        this.attrHtmlUrl = cdk.Token.asString(this.getAtt('HtmlUrl'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrLastIncidentTimestamp = cdk.Token.asString(this.getAtt('LastIncidentTimestamp'));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status'));
    }
}
exports.CfnService = CfnService;
_a = JSII_RTTI_SYMBOL_1;
CfnService[_a] = { fqn: "@cdk-cloudformation/tf-pagerduty-service.CfnService", version: "1.0.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnService.CFN_RESOURCE_TYPE_NAME = "TF::PagerDuty::Service";
//# sourceMappingURL=data:application/json;base64,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