import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * A [service](https://v2.developer.pagerduty.com/v2/page/api-reference#!/Services/get_services) represents something you monitor (like a web service, email service, or database service). It is a container for related incidents that associates them with escalation policies.
 *
 * @schema CfnServiceProps
 */
export interface CfnServiceProps {
    /**
     * Time in seconds that an incident changes to the Triggered State after being Acknowledged. Disabled if set to the `"null"` string.
     * * `escalation_policy` - (Required) The escalation policy used by this service.
     * * `alert_creation` - (Optional) Must be one of two values. PagerDuty receives events from your monitoring systems and can then create incidents in different ways. Value "create_incidents" is default: events will create an incident that cannot be merged. Value "create_alerts_and_incidents" is the alternative: events will create an alert and then add it to a new incident, these incidents can be merged. This option is recommended.
     * * `alert_grouping` - (Optional) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan.
     * * `alert_grouping_timeout` - (Optional) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`.
     *
     * @schema CfnServiceProps#AcknowledgementTimeout
     */
    readonly acknowledgementTimeout?: string;
    /**
     * Must be one of two values. PagerDuty receives events from your monitoring systems and can then create incidents in different ways. Value "create_incidents" is default: events will create an incident that cannot be merged. Value "create_alerts_and_incidents" is the alternative: events will create an alert and then add it to a new incident, these incidents can be merged. This option is recommended.
     * * `alert_grouping` - (Optional) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan.
     * * `alert_grouping_timeout` - (Optional) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`.
     *
     * @schema CfnServiceProps#AlertCreation
     */
    readonly alertCreation?: string;
    /**
     * Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan.
     * * `alert_grouping_timeout` - (Optional) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`.
     *
     * @schema CfnServiceProps#AlertGrouping
     */
    readonly alertGrouping?: string;
    /**
     * The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`.
     *
     * @schema CfnServiceProps#AlertGroupingTimeout
     */
    readonly alertGroupingTimeout?: number;
    /**
     * Time in seconds that an incident is automatically resolved if left open for that long. Disabled if set to the `"null"` string.
     * * `acknowledgement_timeout` - (Optional) Time in seconds that an incident changes to the Triggered State after being Acknowledged. Disabled if set to the `"null"` string.
     * * `escalation_policy` - (Required) The escalation policy used by this service.
     * * `alert_creation` - (Optional) Must be one of two values. PagerDuty receives events from your monitoring systems and can then create incidents in different ways. Value "create_incidents" is default: events will create an incident that cannot be merged. Value "create_alerts_and_incidents" is the alternative: events will create an alert and then add it to a new incident, these incidents can be merged. This option is recommended.
     * * `alert_grouping` - (Optional) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan.
     * * `alert_grouping_timeout` - (Optional) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`.
     *
     * @schema CfnServiceProps#AutoResolveTimeout
     */
    readonly autoResolveTimeout?: string;
    /**
     * A human-friendly description of the service.
     * If not set, a placeholder of "Managed by Terraform" will be set.
     * * `auto_resolve_timeout` - (Optional) Time in seconds that an incident is automatically resolved if left open for that long. Disabled if set to the `"null"` string.
     * * `acknowledgement_timeout` - (Optional) Time in seconds that an incident changes to the Triggered State after being Acknowledged. Disabled if set to the `"null"` string.
     * * `escalation_policy` - (Required) The escalation policy used by this service.
     * * `alert_creation` - (Optional) Must be one of two values. PagerDuty receives events from your monitoring systems and can then create incidents in different ways. Value "create_incidents" is default: events will create an incident that cannot be merged. Value "create_alerts_and_incidents" is the alternative: events will create an alert and then add it to a new incident, these incidents can be merged. This option is recommended.
     * * `alert_grouping` - (Optional) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan.
     * * `alert_grouping_timeout` - (Optional) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`.
     *
     * @schema CfnServiceProps#Description
     */
    readonly description?: string;
    /**
     * The escalation policy used by this service.
     * * `alert_creation` - (Optional) Must be one of two values. PagerDuty receives events from your monitoring systems and can then create incidents in different ways. Value "create_incidents" is default: events will create an incident that cannot be merged. Value "create_alerts_and_incidents" is the alternative: events will create an alert and then add it to a new incident, these incidents can be merged. This option is recommended.
     * * `alert_grouping` - (Optional) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan.
     * * `alert_grouping_timeout` - (Optional) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`.
     *
     * @schema CfnServiceProps#EscalationPolicy
     */
    readonly escalationPolicy: string;
    /**
     * Designates either the start or the end of the scheduled action. Can be `support_hours_start` or `support_hours_end`.
     *
     * @schema CfnServiceProps#Name
     */
    readonly name: string;
    /**
     * @schema CfnServiceProps#IncidentUrgencyRule
     */
    readonly incidentUrgencyRule?: IncidentUrgencyRuleDefinition[];
    /**
     * @schema CfnServiceProps#ScheduledActions
     */
    readonly scheduledActions?: ScheduledActionsDefinition[];
    /**
     * @schema CfnServiceProps#SupportHours
     */
    readonly supportHours?: SupportHoursDefinition[];
}
/**
 * Converts an object of type 'CfnServiceProps' to JSON representation.
 */
export declare function toJson_CfnServiceProps(obj: CfnServiceProps | undefined): Record<string, any> | undefined;
/**
 * @schema IncidentUrgencyRuleDefinition
 */
export interface IncidentUrgencyRuleDefinition {
    /**
     * @schema IncidentUrgencyRuleDefinition#Type
     */
    readonly type: string;
    /**
     * @schema IncidentUrgencyRuleDefinition#Urgency
     */
    readonly urgency?: string;
    /**
     * @schema IncidentUrgencyRuleDefinition#DuringSupportHours
     */
    readonly duringSupportHours?: DuringSupportHoursDefinition[];
    /**
     * @schema IncidentUrgencyRuleDefinition#OutsideSupportHours
     */
    readonly outsideSupportHours?: OutsideSupportHoursDefinition[];
}
/**
 * Converts an object of type 'IncidentUrgencyRuleDefinition' to JSON representation.
 */
export declare function toJson_IncidentUrgencyRuleDefinition(obj: IncidentUrgencyRuleDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema ScheduledActionsDefinition
 */
export interface ScheduledActionsDefinition {
    /**
     * @schema ScheduledActionsDefinition#ToUrgency
     */
    readonly toUrgency?: string;
    /**
     * @schema ScheduledActionsDefinition#Type
     */
    readonly type?: string;
    /**
     * @schema ScheduledActionsDefinition#At
     */
    readonly at?: AtDefinition[];
}
/**
 * Converts an object of type 'ScheduledActionsDefinition' to JSON representation.
 */
export declare function toJson_ScheduledActionsDefinition(obj: ScheduledActionsDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema SupportHoursDefinition
 */
export interface SupportHoursDefinition {
    /**
     * @schema SupportHoursDefinition#DaysOfWeek
     */
    readonly daysOfWeek?: number[];
    /**
     * @schema SupportHoursDefinition#EndTime
     */
    readonly endTime?: string;
    /**
     * @schema SupportHoursDefinition#StartTime
     */
    readonly startTime?: string;
    /**
     * @schema SupportHoursDefinition#TimeZone
     */
    readonly timeZone?: string;
    /**
     * @schema SupportHoursDefinition#Type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'SupportHoursDefinition' to JSON representation.
 */
export declare function toJson_SupportHoursDefinition(obj: SupportHoursDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema DuringSupportHoursDefinition
 */
export interface DuringSupportHoursDefinition {
    /**
     * @schema DuringSupportHoursDefinition#Type
     */
    readonly type?: string;
    /**
     * @schema DuringSupportHoursDefinition#Urgency
     */
    readonly urgency?: string;
}
/**
 * Converts an object of type 'DuringSupportHoursDefinition' to JSON representation.
 */
export declare function toJson_DuringSupportHoursDefinition(obj: DuringSupportHoursDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema OutsideSupportHoursDefinition
 */
export interface OutsideSupportHoursDefinition {
    /**
     * @schema OutsideSupportHoursDefinition#Type
     */
    readonly type?: string;
    /**
     * @schema OutsideSupportHoursDefinition#Urgency
     */
    readonly urgency?: string;
}
/**
 * Converts an object of type 'OutsideSupportHoursDefinition' to JSON representation.
 */
export declare function toJson_OutsideSupportHoursDefinition(obj: OutsideSupportHoursDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema AtDefinition
 */
export interface AtDefinition {
    /**
     * @schema AtDefinition#Name
     */
    readonly name?: string;
    /**
     * @schema AtDefinition#Type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'AtDefinition' to JSON representation.
 */
export declare function toJson_AtDefinition(obj: AtDefinition | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `TF::PagerDuty::Service`
 *
 * @cloudformationResource TF::PagerDuty::Service
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
export declare class CfnService extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "TF::PagerDuty::Service";
    /**
     * Resource props.
     */
    readonly props: CfnServiceProps;
    /**
     * Attribute `TF::PagerDuty::Service.tfcfnid`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrTfcfnid: string;
    /**
     * Attribute `TF::PagerDuty::Service.CreatedAt`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrCreatedAt: string;
    /**
     * Attribute `TF::PagerDuty::Service.HtmlUrl`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrHtmlUrl: string;
    /**
     * Attribute `TF::PagerDuty::Service.Id`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrId: string;
    /**
     * Attribute `TF::PagerDuty::Service.LastIncidentTimestamp`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrLastIncidentTimestamp: string;
    /**
     * Attribute `TF::PagerDuty::Service.Status`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrStatus: string;
    /**
     * Create a new `TF::PagerDuty::Service`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnServiceProps);
}
